/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class UseSpringBootVersionMaven
extends XmlRefactorVisitor {
    private static volatile Set<String> availableReleases;
    private final XPathMatcher parentVersion = new XPathMatcher("/project/parent/version");
    private OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private String requestedVersion;
    private String repositoryUrl = "https://repo1.maven.org/maven2";
    @Nullable
    String latestMatchingVersion;

    public UseSpringBootVersionMaven() {
        this.setCursoringOn();
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"version.requested", this.requestedVersion, "version", this.latestMatchingVersion});
    }

    public void setVersion(String version) {
        this.requestedVersion = version;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Validated validate() {
        return super.validate();
    }

    public Xml visitDocument(Xml.Document document) {
        this.latestMatchingVersion = UseSpringBootVersionMaven.latestMatchingVersion(this.requestedVersion, this.httpClient, this.repositoryUrl);
        return super.visitDocument(document);
    }

    public Xml visitTag(Xml.Tag tag) {
        if (this.parentVersion.matches(this.getCursor()) && tag.getSibling("groupId", this.getCursor()).flatMap(Xml.Tag::getValue).map(groupId -> groupId.equals("org.springframework.boot")).orElse(false).booleanValue() && tag.getSibling("artifactId", this.getCursor()).flatMap(Xml.Tag::getValue).map(artifactId -> artifactId.equals("spring-boot-starter-parent")).orElse(false).booleanValue() && this.latestMatchingVersion != null && tag.getValue().map(v -> !v.equals(this.latestMatchingVersion)).orElse(true).booleanValue()) {
            this.andThen((SourceVisitor)new ChangeTagValue.Scoped(tag, this.latestMatchingVersion));
        }
        return super.visitTag(tag);
    }

    static String latestMatchingVersion(String version, OkHttpClient httpClient, String repositoryUrl) {
        if (!version.contains("+")) {
            return version;
        }
        if (availableReleases == null) {
            Request request = new Request.Builder().url(repositoryUrl + "/org/springframework/boot/spring-boot-starter-parent").build();
            try (Response response = httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                HashSet<String> releases = new HashSet<String>();
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    Matcher releaseMatcher = Pattern.compile("href=\"([^\"]+.RELEASE)/\"").matcher(responseBody.string());
                    while (releaseMatcher.find()) {
                        releases.add(releaseMatcher.group(1));
                    }
                    availableReleases = releases;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return availableReleases.stream().filter(release -> release.matches(version.replace("+", ".+"))).max((r1, r2) -> {
            String[] r2Parts;
            String[] r1Parts = r1.split("\\.");
            int majorVersionComp = r1Parts[0].compareTo((r2Parts = r2.split("\\."))[0]);
            if (majorVersionComp != 0) {
                return majorVersionComp;
            }
            int minorVersionComp = Integer.parseInt(r1Parts[1]) - Integer.parseInt(r2Parts[1]);
            if (minorVersionComp != 0) {
                return minorVersionComp;
            }
            int patchVersionComp = Integer.parseInt(r1Parts[2]) - Integer.parseInt(r2Parts[2]);
            if (patchVersionComp != 0) {
                return patchVersionComp;
            }
            return r1.compareTo((String)r2);
        }).orElse(null);
    }
}

