/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.mockito;

import java.util.Optional;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class MockUtilsToStatic
extends JavaRefactorVisitor {
    private MethodMatcher methodMatcher = new MethodMatcher("org.mockito.internal.util.MockUtil MockUtil()");
    private ChangeMethodTargetToStatic changeMethodTargetToStatic = new ChangeMethodTargetToStatic();

    public MockUtilsToStatic() {
        this.setCursoringOn();
        this.changeMethodTargetToStatic.setMethod("org.mockito.internal.util.MockUtil *(..)");
        this.changeMethodTargetToStatic.setTargetType("org.mockito.internal.util.MockUtil");
    }

    public J visitCompilationUnit(J.CompilationUnit cu) {
        this.andThen((RefactorVisitor)this.changeMethodTargetToStatic);
        return super.visitCompilationUnit(cu);
    }

    public J visitNewClass(J.NewClass newClass) {
        if (this.methodMatcher.matches(newClass)) {
            Optional.ofNullable(this.getCursor().getParent()).filter(it -> it.getTree() instanceof J.VariableDecls.NamedVar).map(Cursor::getParent).map(Cursor::getTree).filter(it -> it instanceof J.VariableDecls).ifPresent(namedVar -> this.andThen((RefactorVisitor)new NamedVarScope((J.VariableDecls)namedVar)));
        }
        return super.visitNewClass(newClass);
    }

    private static class NamedVarScope
    extends JavaRefactorVisitor {
        public final J.VariableDecls namedVar;

        private NamedVarScope(J.VariableDecls namedVar) {
            this.namedVar = namedVar;
            this.setCursoringOn();
        }

        public J visitMultiVariable(J.VariableDecls multiVariable) {
            if (this.namedVar.isScope((Tree)multiVariable)) {
                return new J.Empty(Tree.randomId(), Formatting.EMPTY);
            }
            return super.visitMultiVariable(multiVariable);
        }
    }
}

