/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class ComponentToBeanConfiguration
extends JavaRefactorVisitor {
    private String configurationClass;
    @Nullable
    private J.CompilationUnit existingConfiguration;
    @Nullable
    private J.CompilationUnit springBootApplication;
    private final Set<J.ClassDecl> componentsToCreateBeansDefinitionsFor = new TreeSet<J.ClassDecl>(Comparator.comparing(J.ClassDecl::getSimpleName));

    public ComponentToBeanConfiguration() {
        this.setCursoringOn();
    }

    public Validated validate() {
        return Validated.required((String)"configurationClass", (Object)this.configurationClass);
    }

    public void setConfigurationClass(String configurationClass) {
        this.configurationClass = configurationClass;
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        List components;
        J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        JavaType.Class classType = TypeUtils.asClass((JavaType)classDecl.getType());
        if (classType != null && classType.getFullyQualifiedName().equals(this.configurationClass)) {
            this.existingConfiguration = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
            return c;
        }
        if (!classDecl.findAnnotationsOnClass("@org.springframework.boot.autoconfigure.SpringBootApplication").isEmpty()) {
            this.springBootApplication = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
        }
        if (!(components = Stream.concat(classDecl.findAnnotationsOnClass("@org.springframework.stereotype.Component").stream(), Stream.concat(classDecl.findAnnotationsOnClass("@org.springframework.stereotype.Repository").stream(), classDecl.findAnnotationsOnClass("@org.springframework.stereotype.Service").stream())).collect(Collectors.toList())).isEmpty()) {
            ArrayList annotations = new ArrayList(c.getAnnotations());
            annotations.removeAll(components);
            c = c.withAnnotations(Formatting.formatFirstPrefix(annotations, (String)((J.Annotation)c.getAnnotations().get(0)).getFormatting().getPrefix()));
            this.componentsToCreateBeansDefinitionsFor.add(c);
        }
        return c;
    }

    private class AddBeanDefinitions
    extends JavaRefactorVisitor {
        public AddBeanDefinitions() {
            this.setCursoringOn();
        }

        public boolean isIdempotent() {
            return false;
        }

        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl configClass = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
            if (!configClass.findAnnotationsOnClass("@org.springframework.context.annotation.Configuration").isEmpty()) {
                J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
                assert (cu != null);
                for (J.ClassDecl component : ComponentToBeanConfiguration.this.componentsToCreateBeansDefinitionsFor) {
                    JavaType.Class componentType = TypeUtils.asClass((JavaType)component.getType());
                    if (componentType == null) continue;
                    this.maybeAddImport((JavaType.FullyQualified)componentType);
                    List<J.VariableDecls> fieldCollaborators = this.autowiredFields(component);
                    List<J.VariableDecls> constructorCollaborators = this.constructorInjectedFields(component);
                    List paramTypes = Collections.emptyList();
                    String constructorArgs = "";
                    String params = "";
                    if (!fieldCollaborators.isEmpty()) {
                        params = fieldCollaborators.stream().map(param -> param.getTypeExpr().printTrimmed() + " " + ((J.VariableDecls.NamedVar)param.getVars().iterator().next()).printTrimmed()).collect(Collectors.joining(", "));
                        paramTypes = fieldCollaborators.stream().map(J.VariableDecls::getTypeAsClass).collect(Collectors.toList());
                    } else if (!constructorCollaborators.isEmpty()) {
                        params = constructorCollaborators.stream().map(param -> param.getTypeExpr().printTrimmed() + " " + ((J.VariableDecls.NamedVar)param.getVars().iterator().next()).printTrimmed()).collect(Collectors.joining(", "));
                        paramTypes = constructorCollaborators.stream().map(J.VariableDecls::getTypeAsClass).collect(Collectors.toList());
                        constructorArgs = constructorCollaborators.stream().flatMap(param -> param.getVars().stream()).map(J.VariableDecls.NamedVar::getSimpleName).collect(Collectors.joining(", "));
                    }
                    String className = componentType.getClassName();
                    String lowerClassName = Character.toLowerCase(className.charAt(0)) + className.substring(1);
                    String beanDefinitionSource = "@Bean\n" + className + " " + lowerClassName + "(" + params + ") {\n";
                    if (!fieldCollaborators.isEmpty()) {
                        beanDefinitionSource = beanDefinitionSource + className + " " + lowerClassName + " = new " + className + "();\n";
                        for (J.VariableDecls fieldCollaborator : fieldCollaborators) {
                            beanDefinitionSource = beanDefinitionSource + fieldCollaborator.getVars().stream().findAny().map(field -> {
                                String lowerName = field.getSimpleName();
                                return lowerClassName + ".set" + Character.toUpperCase(lowerName.charAt(0)) + lowerName.substring(1) + "(" + lowerName + ");\n";
                            }).orElse("");
                        }
                        beanDefinitionSource = beanDefinitionSource + "return " + lowerClassName + ";\n";
                    } else {
                        beanDefinitionSource = beanDefinitionSource + "return new " + className + "(" + constructorArgs + ");\n";
                    }
                    beanDefinitionSource = beanDefinitionSource + "}";
                    J.MethodDecl beanDefinition = TreeBuilder.buildMethodDeclaration((JavaParser)JavaParser.fromJavaVersion().classpath(JavaParser.dependenciesFromClasspath((String[])new String[]{"spring-context"})).build(), (J.ClassDecl)configClass, (String)beanDefinitionSource, (JavaType.Class[])((JavaType.Class[])Stream.concat(Stream.of(JavaType.Class.build((String)"org.springframework.context.annotation.Bean"), componentType), paramTypes.stream()).toArray(JavaType.Class[]::new)));
                    this.andThen((RefactorVisitor)new AutoFormat((J)beanDefinition));
                    ArrayList<J> statements = new ArrayList<J>(configClass.getBody().getStatements());
                    statements.add((J)beanDefinition.withPrefix("\n" + beanDefinition.getPrefix()));
                    configClass = configClass.withBody(configClass.getBody().withStatements(statements));
                }
            }
            return configClass;
        }

        private List<J.VariableDecls> autowiredFields(J.ClassDecl component) {
            return component.getFields().stream().filter(f -> f.getAnnotations().stream().anyMatch(ann -> TypeUtils.hasElementType((JavaType)ann.getType(), (String)"org.springframework.beans.factory.annotation.Autowired") || TypeUtils.hasElementType((JavaType)ann.getType(), (String)"javax.inject.Inject"))).collect(Collectors.toList());
        }

        private List<J.VariableDecls> constructorInjectedFields(J.ClassDecl component) {
            return component.getMethods().stream().filter(J.MethodDecl::isConstructor).max(Comparator.comparing(m -> m.getParams().getParams().size())).map(m -> m.getParams().getParams().stream().filter(J.VariableDecls.class::isInstance).map(J.VariableDecls.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
    }
}

