/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.MultiSourceVisitor;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddAnnotation;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class ValueToConfigurationProperties
extends JavaRefactorVisitor
implements MultiSourceVisitor {
    private final List<RefactorVisitor<J>> renameValueFields = new ArrayList<RefactorVisitor<J>>();
    @Nullable
    private String commonPrefix;

    public ValueToConfigurationProperties() {
        this.setCursoringOn();
    }

    public J visitCompilationUnit(J.CompilationUnit cu) {
        this.andThen().addAll(this.renameValueFields);
        return super.visitCompilationUnit(cu);
    }

    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        if (this.commonPrefix != null) {
            this.andThen((RefactorVisitor)new AddAnnotation.Scoped((Tree)c, "org.springframework.boot.context.properties.ConfigurationProperties", new Expression[]{new J.Literal(Tree.randomId(), (Object)this.commonPrefix, '\"' + this.commonPrefix + '\"', JavaType.Primitive.String, Formatting.EMPTY)}));
        }
        return c;
    }

    public J visitMultiVariable(J.VariableDecls multiVariable) {
        J.VariableDecls v = (J.VariableDecls)this.refactor((Tree)multiVariable, x$0 -> super.visitMultiVariable(x$0));
        List value = v.findAnnotations("@org.springframework.beans.factory.annotation.Value");
        if (!value.isEmpty()) {
            String valueFormatPrefix = ((J.Annotation)value.get(0)).getPrefix();
            List annotations = new ArrayList(v.getAnnotations());
            annotations.removeAll(value);
            this.maybeRemoveImport("org.springframework.beans.factory.annotation.Value");
            if (v.getAnnotations().get(0) == value.get(0)) {
                annotations = Formatting.formatFirstPrefix(annotations, (String)valueFormatPrefix);
            }
            v = v.withAnnotations(annotations);
            if (annotations.isEmpty()) {
                if (!v.getModifiers().isEmpty()) {
                    v = v.withModifiers(Formatting.formatFirstPrefix((List)v.getModifiers(), (String)valueFormatPrefix));
                } else if (v.getTypeExpr() != null) {
                    v = v.withTypeExpr((TypeTree)v.getTypeExpr().withPrefix(valueFormatPrefix));
                }
            }
            String valueValue = (String)((J.Literal)((J.Annotation)value.get(0)).getArgs().getArgs().get(0)).getValue();
            valueValue = valueValue.replace("${", "").replace("}", "");
            valueValue = Arrays.stream(valueValue.split("-")).map(part -> Character.toUpperCase(part.charAt(0)) + part.substring(1)).collect(Collectors.joining(""));
            int lastDot = (valueValue = Character.toLowerCase(valueValue.charAt(0)) + valueValue.substring(1)).lastIndexOf(46);
            this.commonPrefix = ValueToConfigurationProperties.longestCommonPrefix(this.commonPrefix, lastDot == -1 ? valueValue : valueValue.substring(0, lastDot));
            String expectedFieldName = valueValue.substring(lastDot + 1);
            String existingFieldName = ((J.VariableDecls.NamedVar)v.getVars().get(0)).getSimpleName();
            if (!existingFieldName.equals(expectedFieldName)) {
                J.ClassDecl enclosingClass = (J.ClassDecl)this.getCursor().firstEnclosing(J.ClassDecl.class);
                assert (enclosingClass != null);
                JavaType.Class classType = TypeUtils.asClass((JavaType)enclosingClass.getType());
                assert (classType != null);
                ChangeFieldName.Scoped renameValueFields = new ChangeFieldName.Scoped(classType, existingFieldName, expectedFieldName);
                String expectedFieldNameCapitalized = Character.toUpperCase(expectedFieldName.charAt(0)) + expectedFieldName.substring(1);
                String existingFieldNameCapitalized = Character.toUpperCase(existingFieldName.charAt(0)) + existingFieldName.substring(1);
                ChangeMethodName renameGetter = new ChangeMethodName();
                renameGetter.setMethod(classType.getFullyQualifiedName() + " get" + existingFieldNameCapitalized + "()");
                renameGetter.setName("get" + expectedFieldNameCapitalized);
                ChangeMethodName renameSetter = new ChangeMethodName();
                renameSetter.setMethod(classType.getFullyQualifiedName() + " set" + existingFieldNameCapitalized + "(..)");
                renameSetter.setName("set" + expectedFieldNameCapitalized);
                this.andThen((RefactorVisitor)renameValueFields);
                this.renameValueFields.add((RefactorVisitor<J>)renameValueFields);
                this.renameValueFields.add((RefactorVisitor<J>)renameGetter);
                this.renameValueFields.add((RefactorVisitor<J>)renameSetter);
            }
        }
        return v;
    }

    static String longestCommonPrefix(@Nullable String s1, String s2) {
        if (s1 == null || s1.equals(s2)) {
            return s2;
        }
        String[] s1Parts = s1.split("\\.");
        String[] s2Parts = s2.split("\\.");
        StringBuilder commonPrefix = new StringBuilder();
        for (int i = 0; i < Math.min(s1Parts.length, s2Parts.length); ++i) {
            if (!s1Parts[i].equals(s2Parts[i])) {
                return commonPrefix.toString();
            }
            if (i > 0) {
                commonPrefix.append('.');
            }
            commonPrefix.append(s1Parts[i]);
        }
        return commonPrefix.toString();
    }
}

