/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.spring.boot2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.GenerateConstructorUsingFields;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

@AutoConfigure
public class ConditionalOnBeanAnyNestedCondition
extends JavaRefactorVisitor {
    private static final String ANY_NESTED_CONDITION = "org.springframework.boot.autoconfigure.condition.AnyNestedCondition";
    private static final FindAnnotations findNestedConditions = new FindAnnotations("@org.springframework.boot.autoconfigure.condition.ConditionalOnBean");

    public J visitClassDecl(J.ClassDecl classDecl) {
        if (((List)findNestedConditions.visit((Tree)classDecl)).size() > 1) {
            this.andThen((RefactorVisitor)new ExtendAnyNestedCondition(classDecl));
        }
        return super.visitClassDecl(classDecl);
    }

    public boolean isIdempotent() {
        return false;
    }

    private static class CallSuperWithConfigurationPhase
    extends JavaRefactorVisitor {
        private static final String CONFIGURATION_PHASE = "org.springframework.context.annotation.ConfigurationPhase";
        private final J.ClassDecl scope;

        private CallSuperWithConfigurationPhase(J.ClassDecl scope) {
            this.scope = scope;
        }

        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
            if (!this.scope.isScope((Tree)classDecl)) {
                return c;
            }
            JavaType.Class configurationPhaseType = JavaType.Class.build((String)CONFIGURATION_PHASE);
            J.MethodInvocation callSuper = new J.MethodInvocation(Tree.randomId(), null, null, J.Ident.build((UUID)Tree.randomId(), (String)"super", (JavaType)JavaType.Class.build((String)ConditionalOnBeanAnyNestedCondition.ANY_NESTED_CONDITION), (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.singletonList(new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"ConfigurationPhase", (JavaType)configurationPhaseType, (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"REGISTER_BEAN", (JavaType)configurationPhaseType, (Formatting)Formatting.EMPTY), (JavaType)configurationPhaseType, Formatting.EMPTY)), Formatting.EMPTY), null, Formatting.EMPTY);
            Optional<J.MethodDecl> ctor = classDecl.getMethods().stream().filter(J.MethodDecl::isConstructor).max(Comparator.comparing(m -> m.getParams().getParams().size()));
            if (ctor.isPresent()) {
                ArrayList<J.MethodInvocation> statements = new ArrayList<J.MethodInvocation>(ctor.get().getBody().getStatements());
                statements.add(0, callSuper.withFormatting(this.formatter.format((Tree)ctor.get().getBody())));
                c = c.withBody(c.getBody().withStatements(c.getBody().getStatements().stream().map(s -> s == ctor.get() ? ((J.MethodDecl)ctor.get()).withBody(((J.MethodDecl)ctor.get()).getBody().withStatements(statements)) : s).collect(Collectors.toList())));
            }
            this.maybeAddImport(CONFIGURATION_PHASE);
            return c;
        }
    }

    private static class ExtendAnyNestedCondition
    extends JavaRefactorVisitor {
        private final J.ClassDecl scope;

        private ExtendAnyNestedCondition(J.ClassDecl scope) {
            this.scope = scope;
        }

        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
            if (this.scope.isScope((Tree)c) && classDecl.getExtends() == null) {
                c = c.withExtends(new J.ClassDecl.Extends(Tree.randomId(), (TypeTree)J.Ident.build((UUID)Tree.randomId(), (String)"AnyNestedCondition", (JavaType)JavaType.Class.build((String)ConditionalOnBeanAnyNestedCondition.ANY_NESTED_CONDITION), (Formatting)Formatting.format((String)" ")), Formatting.format((String)" ")));
                this.maybeAddImport(ConditionalOnBeanAnyNestedCondition.ANY_NESTED_CONDITION);
                if (classDecl.getMethods().stream().noneMatch(J.MethodDecl::isConstructor)) {
                    this.andThen((RefactorVisitor)new GenerateConstructorUsingFields.Scoped(JavaParser.fromJavaVersion().build(), classDecl, Collections.emptyList()));
                }
                this.andThen((RefactorVisitor)new CallSuperWithConfigurationPhase(classDecl));
            }
            return c;
        }
    }
}

