/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.spring;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class NoAutowired
extends JavaRefactorVisitor {
    public J visitMethod(J.MethodDecl method) {
        J.MethodDecl m = (J.MethodDecl)this.refactor((Tree)method, x$0 -> super.visitMethod(x$0));
        List autowireds = method.findAnnotations("@org.springframework.beans.factory.annotation.Autowired");
        if (method.isConstructor() && !autowireds.isEmpty()) {
            J.Annotation autowired = (J.Annotation)autowireds.iterator().next();
            ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(m.getAnnotations());
            String autowiredPrefix = autowired.getFormatting().getPrefix();
            if (annotations.get(0) == autowired && annotations.size() > 1) {
                annotations.set(1, (J.Annotation)((J.Annotation)annotations.get(1)).withPrefix(autowiredPrefix));
            } else {
                m = !m.getModifiers().isEmpty() ? m.withModifiers(Formatting.formatFirstPrefix((List)m.getModifiers(), (String)autowiredPrefix)) : (m.getTypeParameters() != null ? m.withTypeParameters((J.TypeParameters)m.getTypeParameters().withPrefix(autowiredPrefix)) : m.withName((J.Ident)m.getName().withPrefix(autowiredPrefix)));
            }
            annotations.remove(autowired);
            m = m.withAnnotations(annotations);
        }
        return m;
    }
}

