/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.spring.boot2;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.spring.internal.SpringBootReleases;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class UseSpringBootVersionMaven
extends XmlRefactorVisitor {
    private final XPathMatcher parentVersion = new XPathMatcher("/project/parent/version");
    private String requestedVersion;
    @Nullable
    String latestMatchingVersion;

    public UseSpringBootVersionMaven() {
        this.setCursoringOn();
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"version.requested", this.requestedVersion, "version", this.latestMatchingVersion});
    }

    public void setVersion(String version) {
        this.requestedVersion = version;
    }

    public Validated validate() {
        return Validated.required((String)"requestedVersion", (Object)this.requestedVersion);
    }

    public Xml visitDocument(Xml.Document document) {
        this.latestMatchingVersion = new SpringBootReleases().latestMatchingVersion(this.requestedVersion);
        return super.visitDocument(document);
    }

    public Xml visitTag(Xml.Tag tag) {
        if (this.parentVersion.matches(this.getCursor()) && tag.getSibling("groupId", this.getCursor()).flatMap(Xml.Tag::getValue).map(groupId -> groupId.equals("org.springframework.boot")).orElse(false).booleanValue() && tag.getSibling("artifactId", this.getCursor()).flatMap(Xml.Tag::getValue).map(artifactId -> artifactId.equals("spring-boot-starter-parent")).orElse(false).booleanValue() && this.latestMatchingVersion != null && tag.getValue().map(v -> !v.equals(this.latestMatchingVersion)).orElse(true).booleanValue()) {
            this.andThen((RefactorVisitor)new ChangeTagValue.Scoped(tag, this.latestMatchingVersion));
        }
        return super.visitTag(tag);
    }
}

