/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.spring.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class SpringBootReleases {
    private static volatile Set<String> availableReleases;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private final String repositoryUrl = "https://repo1.maven.org/maven2";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream<ModuleDownload> download(String version) {
        List<String> denyList = Arrays.asList("sample", "gradle", "experimental", "legacy", "maven", "tests", "spring-boot-versions");
        Request request = new Request.Builder().url("https://repo1.maven.org/maven2/org/springframework/boot").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            HashSet<String> modules = new HashSet<String>();
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                Matcher moduleMatcher = Pattern.compile("href=\"([^\"]+)/\"").matcher(responseBody.string());
                while (true) {
                    if (!moduleMatcher.find()) {
                        Stream<ModuleDownload> stream2 = modules.stream().map(module -> {
                            Request moduleRequest = new Request.Builder().url("https://repo1.maven.org/maven2/org/springframework/boot/" + module + "/" + version + "/" + module + "-" + version + ".jar").build();
                            try {
                                Response moduleResponse = this.httpClient.newCall(moduleRequest).execute();
                                if (!moduleResponse.isSuccessful()) {
                                    if (moduleResponse.code() == 404) {
                                        return null;
                                    }
                                    throw new IOException("Unexpected code " + moduleResponse);
                                }
                                ResponseBody moduleResponseBody = moduleResponse.body();
                                return moduleResponseBody == null ? null : new ModuleDownload((String)module, moduleResponseBody);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }).filter(Objects::nonNull);
                        return stream2;
                    }
                    String module2 = moduleMatcher.group(1);
                    if (!denyList.stream().noneMatch(module2::contains)) continue;
                    modules.add(module2);
                }
            }
            Stream<ModuleDownload> stream = Stream.empty();
            return stream;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Set<String> allReleases() {
        if (availableReleases == null) {
            Request request = new Request.Builder().url("https://repo1.maven.org/maven2/org/springframework/boot/spring-boot-starter-parent").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                HashSet<String> releases = new HashSet<String>();
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    Matcher releaseMatcher = Pattern.compile("href=\"([^\"]+.RELEASE)/\"").matcher(responseBody.string());
                    while (releaseMatcher.find()) {
                        releases.add(releaseMatcher.group(1));
                    }
                    availableReleases = releases;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return availableReleases;
    }

    public Set<String> latestPatchReleases() {
        return this.allReleases().stream().collect(Collectors.groupingBy(v -> {
            String[] versionParts = v.split("\\.");
            return versionParts[0] + "." + versionParts[1];
        })).values().stream().map(patches -> (String)patches.stream().max((r1, r2) -> {
            String[] r2Parts;
            String[] r1Parts = r1.split("\\.");
            int majorVersionComp = r1Parts[0].compareTo((r2Parts = r2.split("\\."))[0]);
            if (majorVersionComp != 0) {
                return majorVersionComp;
            }
            int minorVersionComp = Integer.parseInt(r1Parts[1]) - Integer.parseInt(r2Parts[1]);
            if (minorVersionComp != 0) {
                return minorVersionComp;
            }
            int patchVersionComp = Integer.parseInt(r1Parts[2]) - Integer.parseInt(r2Parts[2]);
            if (patchVersionComp != 0) {
                return patchVersionComp;
            }
            return r1.compareTo((String)r2);
        }).orElseThrow(() -> new IllegalStateException("Patch list should not be empty"))).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public String latestMatchingVersion(String version) {
        if (!version.contains("+")) {
            return version;
        }
        return this.allReleases().stream().filter(release -> release.matches(version.replace("+", ".+"))).max((r1, r2) -> {
            String[] r2Parts;
            String[] r1Parts = r1.split("\\.");
            int majorVersionComp = r1Parts[0].compareTo((r2Parts = r2.split("\\."))[0]);
            if (majorVersionComp != 0) {
                return majorVersionComp;
            }
            int minorVersionComp = Integer.parseInt(r1Parts[1]) - Integer.parseInt(r2Parts[1]);
            if (minorVersionComp != 0) {
                return minorVersionComp;
            }
            int patchVersionComp = Integer.parseInt(r1Parts[2]) - Integer.parseInt(r2Parts[2]);
            if (patchVersionComp != 0) {
                return patchVersionComp;
            }
            return r1.compareTo((String)r2);
        }).orElse(null);
    }

    public static class ModuleDownload {
        private final String moduleName;
        private final ResponseBody body;

        public ModuleDownload(String moduleName, ResponseBody body) {
            this.moduleName = moduleName;
            this.body = body;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public ResponseBody getBody() {
            return this.body;
        }
    }
}

