/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class RuntimeUtils {
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    private RuntimeUtils() {
    }

    public static String exec(String cmd, boolean block) {
        try {
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            if (block) {
                StringBuilder sb = new StringBuilder();
                StreamGobbler streamGobbler = new StreamGobbler(proc.getInputStream(), proc.getErrorStream(), sb::append);
                Future<?> future = executorService.submit(streamGobbler);
                if (!proc.waitFor(30L, TimeUnit.SECONDS)) {
                    throw new IOException("Execution timed out for command: " + cmd);
                }
                future.get(10L, TimeUnit.SECONDS);
                if (proc.exitValue() != 0) {
                    throw new IOException(sb.toString());
                }
                return sb.toString();
            }
            return "";
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private final InputStream inputStream;
        private final InputStream errorStream;
        private final Consumer<String> consumer;

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
            new BufferedReader(new InputStreamReader(this.errorStream)).lines().forEach(this.consumer);
        }

        public StreamGobbler(InputStream inputStream, InputStream errorStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.errorStream = errorStream;
            this.consumer = consumer;
        }
    }
}

