/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.search;

import io.moderne.ai.EmbeddingModelClient;
import io.moderne.ai.table.EmbeddingPerformance;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public class FindCodeThatResembles
extends Recipe {
    @Option(displayName="Resembles", description="The text, either a natural language description or a code sample, that you are looking for.", example="HTTP request with Content-Type application/json")
    private final String resembles;
    @Option(displayName="Method filters", description="Since AI based matching has a higher latency than rules based matching, filter the methods that are searched for the `resembles` text.", example="kong.unirest.* *(..)")
    private final List<String> methodFilters;
    @Option(displayName="Hugging Face token", description="The token to use for the HuggingFace API. Create a [read token](https://huggingface.co/settings/tokens).", example="hf_*****")
    private final String huggingFaceToken;
    private transient EmbeddingModelClient modelClient;
    private final transient EmbeddingPerformance performance = new EmbeddingPerformance(this);

    public String getDisplayName() {
        return "Find HTTP requests with a particular `Content-Type` header";
    }

    public String getDescription() {
        return "This recipe uses a hybrid rules-based and AI approach to find HTTP requests with a particular `Content-Type` header.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final ArrayList<MethodMatcher> methodMatchers = new ArrayList<MethodMatcher>(this.methodFilters.size());
        for (String m : this.methodFilters) {
            methodMatchers.add(new MethodMatcher(m, true));
        }
        ArrayList<UsesMethod> preconditions = new ArrayList<UsesMethod>(methodMatchers.size());
        for (MethodMatcher m : methodMatchers) {
            preconditions.add(new UsesMethod(m));
        }
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])preconditions.toArray(new TreeVisitor[0])), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Nullable
            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    this.getCursor().putMessage("count", (Object)new AtomicInteger());
                    this.getCursor().putMessage("max", (Object)new AtomicLong());
                    this.getCursor().putMessage("histogram", (Object)new EmbeddingPerformance.Histogram());
                    J visit = (J)super.visit(tree, (Object)ctx);
                    if (((AtomicInteger)this.getCursor().getMessage("count", (Object)new AtomicInteger())).get() > 0) {
                        Duration max = Duration.ofNanos(Objects.requireNonNull((AtomicLong)this.getCursor().getMessage("max")).get());
                        FindCodeThatResembles.this.performance.insertRow(ctx, new EmbeddingPerformance.Row(((SourceFile)tree).getSourcePath().toString(), Objects.requireNonNull((AtomicInteger)this.getCursor().getMessage("count")).get(), Objects.requireNonNull((EmbeddingPerformance.Histogram)this.getCursor().getMessage("histogram")).getBuckets(), max));
                    }
                    return visit;
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                boolean matches = false;
                for (MethodMatcher methodMatcher : methodMatchers) {
                    if (!methodMatcher.matches((MethodCall)method)) continue;
                    matches = true;
                }
                if (!matches) {
                    return super.visitMethodInvocation(method, (Object)ctx);
                }
                if (FindCodeThatResembles.this.modelClient == null) {
                    FindCodeThatResembles.this.modelClient = new EmbeddingModelClient(FindCodeThatResembles.this.huggingFaceToken);
                    FindCodeThatResembles.this.modelClient.start();
                }
                EmbeddingModelClient.Relatedness related = FindCodeThatResembles.this.modelClient.getRelatedness(FindCodeThatResembles.this.resembles, method.printTrimmed(this.getCursor()));
                for (Duration timing : related.getEmbeddingTimings()) {
                    Objects.requireNonNull((AtomicInteger)this.getCursor().getNearestMessage("count")).incrementAndGet();
                    Objects.requireNonNull((EmbeddingPerformance.Histogram)this.getCursor().getNearestMessage("histogram")).add(timing);
                    AtomicLong max = (AtomicLong)this.getCursor().getNearestMessage("max");
                    if (Objects.requireNonNull(max).get() >= timing.toNanos()) continue;
                    max.set(timing.toNanos());
                }
                return related.isRelated() ? (J.MethodInvocation)SearchResult.found((Tree)method) : super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    public FindCodeThatResembles(String resembles, List<String> methodFilters, String huggingFaceToken) {
        this.resembles = resembles;
        this.methodFilters = methodFilters;
        this.huggingFaceToken = huggingFaceToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCodeThatResembles)) {
            return false;
        }
        FindCodeThatResembles other = (FindCodeThatResembles)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$resembles = this.resembles;
        String other$resembles = other.resembles;
        if (this$resembles == null ? other$resembles != null : !this$resembles.equals(other$resembles)) {
            return false;
        }
        List<String> this$methodFilters = this.methodFilters;
        List<String> other$methodFilters = other.methodFilters;
        if (this$methodFilters == null ? other$methodFilters != null : !((Object)this$methodFilters).equals(other$methodFilters)) {
            return false;
        }
        String this$huggingFaceToken = this.huggingFaceToken;
        String other$huggingFaceToken = other.huggingFaceToken;
        return !(this$huggingFaceToken == null ? other$huggingFaceToken != null : !this$huggingFaceToken.equals(other$huggingFaceToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindCodeThatResembles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resembles = this.resembles;
        result = result * 59 + ($resembles == null ? 43 : $resembles.hashCode());
        List<String> $methodFilters = this.methodFilters;
        result = result * 59 + ($methodFilters == null ? 43 : ((Object)$methodFilters).hashCode());
        String $huggingFaceToken = this.huggingFaceToken;
        result = result * 59 + ($huggingFaceToken == null ? 43 : $huggingFaceToken.hashCode());
        return result;
    }
}

