/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;

public class EmbeddingModelClient {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(3);
    private static final Path MODELS_DIR = Paths.get(System.getProperty("user.home") + "/.moderne/models", new String[0]);
    @Nullable
    private static EmbeddingModelClient INSTANCE;
    private final ObjectMapper mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Map<String, float[]> embeddingCache = Collections.synchronizedMap(new LinkedHashMap<String, float[]>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, float[]> eldest) {
            return this.size() > 1000;
        }
    });

    public static synchronized EmbeddingModelClient getInstance() {
        if (INSTANCE == null && (INSTANCE = new EmbeddingModelClient()).checkForUpRequest() != 200) {
            String cmd = String.format("/usr/bin/python3 'import gradio\ngradio.'", MODELS_DIR);
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            INSTANCE.start();
        }
        return INSTANCE;
    }

    private void start() {
        Path pyLauncher = MODELS_DIR.resolve("get_embedding.py");
        try {
            Files.copy(Objects.requireNonNull(EmbeddingModelClient.class.getResourceAsStream("/get_embedding.py")), pyLauncher, StandardCopyOption.REPLACE_EXISTING);
            StringWriter sw = new StringWriter();
            PrintWriter procOut = new PrintWriter(sw);
            String cmd = String.format("/usr/bin/python3 %s/get_embedding.py", MODELS_DIR);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            EXECUTOR_SERVICE.submit(() -> {
                new BufferedReader(new InputStreamReader(proc.getInputStream())).lines().forEach(procOut::println);
                new BufferedReader(new InputStreamReader(proc.getErrorStream())).lines().forEach(procOut::println);
            });
            if (!this.checkForUp(proc)) {
                throw new IllegalStateException("Unable to start model daemon. Output of process is:\n" + sw);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkForUp(Process proc) {
        for (int i = 0; i < 60; ++i) {
            try {
                if (!proc.isAlive() && proc.exitValue() != 0) {
                    return false;
                }
                if (this.checkForUpRequest() == 200) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private int checkForUpRequest() {
        try {
            HttpResponse response = Unirest.head((String)"http://127.0.0.1:7860").asString();
            return response.getStatus();
        }
        catch (UnirestException e) {
            return 523;
        }
    }

    public Relatedness getRelatedness(String t1, String t2, double threshold) {
        float[] e2;
        ArrayList<Duration> timings = new ArrayList<Duration>(2);
        float[] e1 = this.embeddingCache.computeIfAbsent(t1, this.timeEmbedding(timings));
        return new Relatedness(EmbeddingModelClient.dist(e1, e2 = this.embeddingCache.computeIfAbsent(t2.replace("\n", ""), this.timeEmbedding(timings))) <= threshold, timings);
    }

    private Function<String, float[]> timeEmbedding(List<Duration> timings) {
        return t -> {
            long start = System.nanoTime();
            float[] em = this.getEmbedding((String)t);
            if (timings.isEmpty()) {
                timings.add(Duration.ofNanos(System.nanoTime() - start));
            }
            return em;
        };
    }

    public double getDistance(String t1, String t2) {
        ArrayList<Duration> timings = new ArrayList<Duration>(2);
        float[] e1 = this.embeddingCache.computeIfAbsent(t1, this.timeEmbedding(timings));
        float[] e2 = this.embeddingCache.computeIfAbsent(t2, this.timeEmbedding(timings));
        return EmbeddingModelClient.dist(e1, e2);
    }

    private static double dist(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have the same dimension");
        }
        float sumOfSquaredDifferences = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            float diff = v1[i] - v2[i];
            sumOfSquaredDifferences += diff * diff;
        }
        return 1.0 - Math.sqrt(sumOfSquaredDifferences);
    }

    public float[] getEmbedding(String text) {
        HttpUrlConnectionSender http = new HttpUrlConnectionSender(Duration.ofSeconds(20L), Duration.ofSeconds(30L));
        HttpSender.Response raw = null;
        try {
            raw = http.post("http://127.0.0.1:7860/run/predict").withContent("application/json", this.mapper.writeValueAsBytes((Object)new GradioRequest(text))).send();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (!raw.isSuccessful()) {
            throw new IllegalStateException("Unable to get embedding. HTTP " + raw.getClass());
        }
        float[] embeddings = null;
        try {
            embeddings = ((GradioResponse)this.mapper.readValue(raw.getBodyAsBytes(), GradioResponse.class)).getEmbedding();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return embeddings;
    }

    static {
        if (!Files.exists(MODELS_DIR, new LinkOption[0]) && !MODELS_DIR.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to create models directory at " + MODELS_DIR);
        }
    }

    public static final class Relatedness {
        private final boolean isRelated;
        private final List<Duration> embeddingTimings;

        public Relatedness(boolean isRelated, List<Duration> embeddingTimings) {
            this.isRelated = isRelated;
            this.embeddingTimings = embeddingTimings;
        }

        public boolean isRelated() {
            return this.isRelated;
        }

        public List<Duration> getEmbeddingTimings() {
            return this.embeddingTimings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Relatedness)) {
                return false;
            }
            Relatedness other = (Relatedness)o;
            if (this.isRelated() != other.isRelated()) {
                return false;
            }
            List<Duration> this$embeddingTimings = this.getEmbeddingTimings();
            List<Duration> other$embeddingTimings = other.getEmbeddingTimings();
            return !(this$embeddingTimings == null ? other$embeddingTimings != null : !((Object)this$embeddingTimings).equals(other$embeddingTimings));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRelated() ? 79 : 97);
            List<Duration> $embeddingTimings = this.getEmbeddingTimings();
            result = result * 59 + ($embeddingTimings == null ? 43 : ((Object)$embeddingTimings).hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingModelClient.Relatedness(isRelated=" + this.isRelated() + ", embeddingTimings=" + this.getEmbeddingTimings() + ")";
        }
    }

    private static final class GradioRequest {
        private final String[] data;

        GradioRequest(String ... data) {
            this.data = data;
        }

        public String[] getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioRequest)) {
                return false;
            }
            GradioRequest other = (GradioRequest)o;
            return Arrays.deepEquals(this.getData(), other.getData());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            return result;
        }

        public String toString() {
            return "EmbeddingModelClient.GradioRequest(data=" + Arrays.deepToString(this.getData()) + ")";
        }
    }

    private static final class GradioResponse {
        private final List<String> data;

        public float[] getEmbedding() {
            String d = this.data.get(0);
            String[] emStr = d.substring(1, d.length() - 1).split(",");
            float[] em = new float[emStr.length];
            for (int i = 0; i < emStr.length; ++i) {
                em[i] = Float.parseFloat(emStr[i]);
            }
            return em;
        }

        public GradioResponse(List<String> data) {
            this.data = data;
        }

        public List<String> getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioResponse)) {
                return false;
            }
            GradioResponse other = (GradioResponse)o;
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingModelClient.GradioResponse(data=" + this.getData() + ")";
        }
    }
}

