/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.table;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;

public class EmbeddingPerformance
extends DataTable<Row> {
    public EmbeddingPerformance(Recipe recipe) {
        super(recipe, "Embedding performance", "Latency characteristics of uses of embedding models.");
    }

    public static final class Row {
        @Column(displayName="Source file", description="The source file that the method call occurred in.")
        private final String sourceFile;
        @Column(displayName="Number of requests", description="The count of requests made to the model.")
        private final int count;
        @Column(displayName="Histogram", description="The latency histogram of the requests made to the model (counts). The histogram is a non-cumulative fixed distribution of 100 buckets of 0.01 second each.")
        @Nullable
        private final List<Integer> histogram;
        @Column(displayName="Max latency", description="The maximum embedding latency.")
        private final Duration max;

        public Row(String sourceFile, int count, List<Integer> histogram, Duration max) {
            this.sourceFile = sourceFile;
            this.count = count;
            this.histogram = histogram;
            this.max = max;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public int getCount() {
            return this.count;
        }

        public List<Integer> getHistogram() {
            return this.histogram;
        }

        public Duration getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getCount() != other.getCount()) {
                return false;
            }
            String this$sourceFile = this.getSourceFile();
            String other$sourceFile = other.getSourceFile();
            if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
                return false;
            }
            List<Integer> this$histogram = this.getHistogram();
            List<Integer> other$histogram = other.getHistogram();
            if (this$histogram == null ? other$histogram != null : !((Object)this$histogram).equals(other$histogram)) {
                return false;
            }
            Duration this$max = this.getMax();
            Duration other$max = other.getMax();
            return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            String $sourceFile = this.getSourceFile();
            result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
            List<Integer> $histogram = this.getHistogram();
            result = result * 59 + ($histogram == null ? 43 : ((Object)$histogram).hashCode());
            Duration $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingPerformance.Row(sourceFile=" + this.getSourceFile() + ", count=" + this.getCount() + ", histogram=" + this.getHistogram() + ", max=" + this.getMax() + ")";
        }
    }

    public static class Histogram {
        private static final int BUCKETS = 100;
        private static final long MAX_NANOS = 1000000000L;
        @Nullable
        List<Integer> buckets;

        public void add(Duration duration) {
            int bucket = (int)(duration.toNanos() / 10000000L);
            if (bucket < 100) {
                if (this.buckets == null) {
                    this.buckets = new ArrayList<Integer>(100);
                    for (int i = 0; i < 100; ++i) {
                        this.buckets.add(0);
                    }
                }
                this.buckets.set(bucket, this.buckets.get(bucket) + 1);
            }
        }

        public List<Integer> getBuckets() {
            return this.buckets;
        }
    }
}

