/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;

public class ClusteringClient {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(3);
    private static final Path MODELS_DIR = Paths.get(System.getProperty("user.home") + "/.moderne/models", new String[0]);
    @Nullable
    private static ClusteringClient INSTANCE;
    private final ObjectMapper mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    public static synchronized ClusteringClient getInstance() {
        if (INSTANCE == null && (INSTANCE = new ClusteringClient()).checkForUpRequest() != 200) {
            INSTANCE.start();
        }
        return INSTANCE;
    }

    private void start() {
        Path pyLauncher = MODELS_DIR.resolve("get_centers.py");
        try {
            Files.copy(Objects.requireNonNull(ClusteringClient.class.getResourceAsStream("/get_centers.py")), pyLauncher, StandardCopyOption.REPLACE_EXISTING);
            StringWriter sw = new StringWriter();
            PrintWriter procOut = new PrintWriter(sw);
            String cmd = String.format("/usr/bin/python3 %s/get_centers.py", MODELS_DIR);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            EXECUTOR_SERVICE.submit(() -> {
                new BufferedReader(new InputStreamReader(proc.getInputStream())).lines().forEach(procOut::println);
                new BufferedReader(new InputStreamReader(proc.getErrorStream())).lines().forEach(procOut::println);
            });
            if (!this.checkForUp(proc)) {
                throw new IllegalStateException("Unable to start model daemon. Output of process is:\n" + sw);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkForUp(Process proc) {
        for (int i = 0; i < 60; ++i) {
            try {
                if (!proc.isAlive() && proc.exitValue() != 0) {
                    return false;
                }
                if (this.checkForUpRequest() == 200) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private int checkForUpRequest() {
        try {
            HttpResponse response = Unirest.head((String)"http://127.0.0.1:7876").asString();
            return response.getStatus();
        }
        catch (UnirestException e) {
            return 523;
        }
    }

    public String embeddingsToString(List<float[]> embeddings) {
        StringBuilder embeddingsToString = new StringBuilder();
        for (int i = 0; i < embeddings.size(); ++i) {
            embeddingsToString.append(Arrays.toString(embeddings.get(i)));
            if (i >= embeddings.size() - 1) continue;
            embeddingsToString.append(",");
        }
        return "[" + embeddingsToString + "]";
    }

    public int[] getCenters(List<float[]> embeddings, int numberOfCenters) {
        int[] nArray;
        block9: {
            HttpUrlConnectionSender http = new HttpUrlConnectionSender(Duration.ofSeconds(20L), Duration.ofSeconds(30L));
            HttpSender.Response raw = http.post("http://127.0.0.1:7876/run/predict").withContent("application/json", this.mapper.writeValueAsBytes((Object)new GradioRequest(new Object[]{this.embeddingsToString(embeddings), numberOfCenters}))).send();
            try {
                if (!raw.isSuccessful()) {
                    throw new IllegalStateException("Unable to get embedding. HTTP " + raw.getClass());
                }
                nArray = ((GradioResponse)this.mapper.readValue(raw.getBodyAsBytes(), GradioResponse.class)).getCenters();
                if (raw == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (raw != null) {
                        try {
                            raw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            raw.close();
        }
        return nArray;
    }

    static {
        if (!Files.exists(MODELS_DIR, new LinkOption[0]) && !MODELS_DIR.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to create models directory at " + MODELS_DIR);
        }
    }

    private static final class GradioRequest {
        private final Object[] data;

        public GradioRequest(Object[] data) {
            this.data = data;
        }

        public Object[] getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioRequest)) {
                return false;
            }
            GradioRequest other = (GradioRequest)o;
            return Arrays.deepEquals(this.getData(), other.getData());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            return result;
        }

        public String toString() {
            return "ClusteringClient.GradioRequest(data=" + Arrays.deepToString(this.getData()) + ")";
        }
    }

    private static final class GradioResponse {
        private final List<String> data;

        public int[] getCenters() {
            return Arrays.stream(this.data.get(0).substring(1, this.data.get(0).length() - 1).trim().split("[\\s,]+")).map(String::trim).mapToInt(Integer::parseInt).toArray();
        }

        public GradioResponse(List<String> data) {
            this.data = data;
        }

        public List<String> getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioResponse)) {
                return false;
            }
            GradioResponse other = (GradioResponse)o;
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "ClusteringClient.GradioResponse(data=" + this.getData() + ")";
        }
    }
}

