/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class CodeSearch
extends DataTable<Row> {
    public CodeSearch(Recipe recipe) {
        super(recipe, "Code Search", "Searches for method invocations that resemble a natural language query.");
    }

    public static final class Row {
        @Column(displayName="Source", description="Source")
        private final String source;
        @Column(displayName="Method", description="Method invocation")
        private final String method;
        @Column(displayName="Query", description="Natural language query")
        private final String query;
        @Column(displayName="Result of first models", description="First two embeddings models result, where -1 means negative match, 0 means unsure, and 1 means positive match.")
        private final int resultEmbedding;
        @Column(displayName="Result of second model", description="Second generative model's result, where -1 means negative match and 1 means positive match. If the model was never queried, then the result is 0.")
        private final int resultGenerative;

        public Row(String source, String method, String query, int resultEmbedding, int resultGenerative) {
            this.source = source;
            this.method = method;
            this.query = query;
            this.resultEmbedding = resultEmbedding;
            this.resultGenerative = resultGenerative;
        }

        public String getSource() {
            return this.source;
        }

        public String getMethod() {
            return this.method;
        }

        public String getQuery() {
            return this.query;
        }

        public int getResultEmbedding() {
            return this.resultEmbedding;
        }

        public int getResultGenerative() {
            return this.resultGenerative;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getResultEmbedding() != other.getResultEmbedding()) {
                return false;
            }
            if (this.getResultGenerative() != other.getResultGenerative()) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            return !(this$query == null ? other$query != null : !this$query.equals(other$query));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getResultEmbedding();
            result = result * 59 + this.getResultGenerative();
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            return result;
        }

        public String toString() {
            return "CodeSearch.Row(source=" + this.getSource() + ", method=" + this.getMethod() + ", query=" + this.getQuery() + ", resultEmbedding=" + this.getResultEmbedding() + ", resultGenerative=" + this.getResultGenerative() + ")";
        }
    }
}

