/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.transposeCapitalization;

import java.util.List;
import java.util.Random;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;

public final class SpongeBobCase
extends Recipe {
    public String getDisplayName() {
        return "SpongeBob-case comments";
    }

    public String getDescription() {
        return "Change all your comments to be SpongeBob-case.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final Random random = new Random(279572L);

            private String toSpongeBobCase(String input) {
                StringBuilder sb = new StringBuilder(input.length());
                boolean toUpperCase = this.random.nextBoolean();
                for (char c : input.toCharArray()) {
                    if (Character.isLetter(c)) {
                        if (this.random.nextInt(100) < 85) {
                            toUpperCase = !toUpperCase;
                        }
                        c = toUpperCase ? Character.toUpperCase(c) : Character.toLowerCase(c);
                    }
                    sb.append(c);
                }
                return sb.toString();
            }

            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                return space.withComments(ListUtils.map((List)space.getComments(), comment -> {
                    if (comment instanceof TextComment) {
                        TextComment tc = (TextComment)comment;
                        return tc.withText(this.toSpongeBobCase(tc.getText()));
                    }
                    return comment;
                }));
            }
        };
    }

    public String toString() {
        return "SpongeBobCase()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpongeBobCase)) {
            return false;
        }
        SpongeBobCase other = (SpongeBobCase)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpongeBobCase;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

