/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import io.moderne.ai.LanguageDetectorModelClient;
import io.moderne.ai.SpellCheckerClient;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;

public final class SpellCheckCommentsInFrench
extends Recipe {
    public String getDisplayName() {
        return "Fix mis-encoded comments in French";
    }

    public String getDescription() {
        return "Use spellchecker to fix mis-encoded French comments. Mis-encoded comments will contain either '?' or '\ufffd'.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
                return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                    public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext ctx) {
                        Javadoc.DocComment dc = (Javadoc.DocComment)super.visitDocComment(javadoc, (Object)ctx);
                        dc = dc.withBody(ListUtils.map((List)dc.getBody(), docLine -> {
                            String fixedComment;
                            String commentText;
                            if (docLine instanceof Javadoc.Text && !(commentText = ((Javadoc.Text)docLine).getText()).trim().isEmpty() && "fr".equals(LanguageDetectorModelClient.getInstance().getLanguage(commentText).getLanguage()) && !(fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText)).equals(commentText)) {
                                docLine = ((Javadoc.Text)docLine).withText(fixedComment);
                            }
                            return docLine;
                        }));
                        return dc;
                    }
                };
            }

            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                Space s = super.visitSpace(space, loc, (Object)ctx);
                return s.withComments(ListUtils.map((List)s.getComments(), c -> {
                    String fixedComment;
                    TextComment tc;
                    String commentText;
                    if (c instanceof TextComment && !(commentText = (tc = (TextComment)c).getText()).isEmpty() && "fr".equals(LanguageDetectorModelClient.getInstance().getLanguage(commentText).getLanguage()) && !(fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText)).equals(commentText)) {
                        return tc.withText(fixedComment);
                    }
                    return c;
                }));
            }
        };
    }

    public String toString() {
        return "SpellCheckCommentsInFrench()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpellCheckCommentsInFrench)) {
            return false;
        }
        SpellCheckCommentsInFrench other = (SpellCheckCommentsInFrench)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpellCheckCommentsInFrench;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

