/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;

public class AgentGenerativeModelClient {
    @Nullable
    private static AgentGenerativeModelClient INSTANCE;
    private static HashMap<String, String> methodsToSample;
    private final ObjectMapper mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final ExecutorService EXECUTOR_SERVICE;
    static String pathToModel;
    static String pathToLLama;
    static String pathToFiles;
    static String port;

    public static synchronized AgentGenerativeModelClient getInstance() {
        if (INSTANCE == null) {
            Runtime runtime;
            PrintWriter procOut;
            StringWriter sw;
            File f = new File(pathToLLama + "/main");
            if (!f.exists() || f.isDirectory()) {
                sw = new StringWriter();
                procOut = new PrintWriter(sw);
                try {
                    runtime = Runtime.getRuntime();
                    Process proc_make = runtime.exec(new String[]{"/bin/sh", "-c", "make -C " + pathToLLama});
                    proc_make.waitFor();
                    new BufferedReader(new InputStreamReader(proc_make.getInputStream())).lines().forEach(procOut::println);
                    new BufferedReader(new InputStreamReader(proc_make.getErrorStream())).lines().forEach(procOut::println);
                    if (proc_make.exitValue() != 0) {
                        throw new RuntimeException("Failed to make llama.cpp at " + pathToLLama + "\n" + sw);
                    }
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e + "\nOutput: " + sw);
                }
            }
            if ((INSTANCE = new AgentGenerativeModelClient()).checkForUpRequest() != 200) {
                sw = new StringWriter();
                procOut = new PrintWriter(sw);
                try {
                    runtime = Runtime.getRuntime();
                    Process proc_server = runtime.exec(new String[]{"/bin/sh", "-c", pathToLLama + "/server -m " + pathToModel + " --port " + port});
                    EXECUTOR_SERVICE.submit(() -> {
                        new BufferedReader(new InputStreamReader(proc_server.getInputStream())).lines().forEach(procOut::println);
                        new BufferedReader(new InputStreamReader(proc_server.getErrorStream())).lines().forEach(procOut::println);
                    });
                    if (!INSTANCE.checkForUp()) {
                        throw new RuntimeException("Failed to start server\n" + sw);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e + "\nOutput: " + sw);
                }
            }
            return INSTANCE;
        }
        return INSTANCE;
    }

    private int checkForUpRequest() {
        try {
            HttpResponse response = Unirest.head((String)("http://127.0.0.1:" + port)).asString();
            return response.getStatus();
        }
        catch (UnirestException e) {
            return 523;
        }
    }

    private boolean checkForUp() {
        for (int i = 0; i < 60; ++i) {
            try {
                if (this.checkForUpRequest() == 200) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static void populateMethodsToSample(String pathToCenters) {
        HashMap<String, String> tempMethodsToSample = new HashMap<String, String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pathToCenters));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String source = line.split(" ")[0];
                String methodCall = line.split(" ")[1];
                tempMethodsToSample.put(source, methodCall);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read which methods to sample. " + e);
        }
        methodsToSample = tempMethodsToSample;
    }

    public static HashMap<String, String> getMethodsToSample() {
        return methodsToSample;
    }

    public ArrayList<String> getRecommendations(String code) {
        ArrayList<String> arrayList;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(pathToFiles + "prompt.txt"));
        try {
            HttpSender.Response raw;
            String line;
            StringBuilder promptContent = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                promptContent.append(line).append("\n");
            }
            String text = "[INST]" + promptContent + code + "```\n[/INST]1.";
            HttpUrlConnectionSender http = new HttpUrlConnectionSender(Duration.ofSeconds(20L), Duration.ofSeconds(90L));
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("stream", false);
            input.put("prompt", text);
            input.put("temperature", 0.5);
            input.put("n_predict", 150);
            try {
                raw = http.post("http://127.0.0.1:" + port + "/completion").withContent("application/json", this.mapper.writeValueAsBytes(input)).send();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            if (!raw.isSuccessful()) {
                throw new IllegalStateException("Unable to get recommendations. HTTP " + raw.getClass());
            }
            String textResponse = ((LlamaResponse)this.mapper.readValue(raw.getBodyAsBytes(), LlamaResponse.class)).getResponse();
            ArrayList<String> recommendations = this.parseRecommendations("1." + textResponse);
            if (recommendations.isEmpty()) {
                String logLine;
                BufferedReader bufferedReaderLog = new BufferedReader(new FileReader(pathToFiles + "llama_log.txt"));
                StringBuilder logContent = new StringBuilder();
                while ((logLine = bufferedReaderLog.readLine()) != null) {
                    logContent.append(logLine).append("\n");
                }
                bufferedReaderLog.close();
                throw new RuntimeException("Logs: " + logContent);
            }
            arrayList = recommendations;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    public ArrayList<String> parseRecommendations(String recommendations) {
        if (recommendations.equals("[]")) {
            return new ArrayList<String>();
        }
        String patternString = "\\b\\d+[.:\\-]\\s+(.*?)\\s*(?=\\b\\d+[.:\\-]|\\Z)";
        Pattern pattern = Pattern.compile(patternString, 32);
        Matcher matcher = pattern.matcher(recommendations);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        return matches;
    }

    public boolean isRelated(String query, String code, double threshold) {
        boolean relatedResponse;
        HttpSender.Response raw;
        String promptContent = "Does this query match the code snippet?\n";
        promptContent = promptContent + "Query: " + query + "\n";
        promptContent = promptContent + "Code: " + code + "\n";
        promptContent = promptContent + "Answer as 'ANS: Yes' or 'ANS: No'.\n";
        promptContent = "[INST]" + promptContent + "[/INST]ANS:";
        HttpUrlConnectionSender http = new HttpUrlConnectionSender(Duration.ofSeconds(20L), Duration.ofSeconds(60L));
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("stream", false);
        input.put("prompt", promptContent);
        input.put("temperature", 0.0);
        input.put("n_predict", 3);
        input.put("n_probs", 10);
        try {
            raw = http.post("http://127.0.0.1:" + port + "/completion").withContent("application/json", this.mapper.writeValueAsBytes(input)).send();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (!raw.isSuccessful()) {
            throw new IllegalStateException("Unable to get response from server. HTTP " + raw.getClass());
        }
        try {
            relatedResponse = ((LlamaResponseProbabilities)this.mapper.readValue(raw.getBodyAsBytes(), LlamaResponseProbabilities.class)).isRelated(threshold);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return relatedResponse;
    }

    private boolean parseRelated(String s) {
        return s.contains("Yes") || s.contains("yes");
    }

    static {
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(3);
        pathToModel = "/MODELS/codellama.gguf";
        pathToLLama = "/app/llama.cpp";
        pathToFiles = "/app/";
        port = "7878";
    }

    private static final class LlamaResponse {
        private final String content;

        public String getResponse() {
            return this.content;
        }

        @Generated
        public LlamaResponse(String content) {
            this.content = content;
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LlamaResponse)) {
                return false;
            }
            LlamaResponse other = (LlamaResponse)o;
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AgentGenerativeModelClient.LlamaResponse(content=" + this.getContent() + ")";
        }
    }

    public static final class LlamaResponseProbabilities {
        private final List<CompletionProbability> completionProbabilities;
        private final String content;
        private final boolean multimodal;
        private final int slotId;
        private final boolean stop;

        @JsonProperty(value="completion_probabilities")
        public List<CompletionProbability> getCompletionProbabilities() {
            return this.completionProbabilities;
        }

        public boolean isRelated(double threshold) {
            for (CompletionProbability cp : this.completionProbabilities) {
                if (!cp.getContent().equals(" Yes")) continue;
                return cp.getProbs().get(0).getProb() >= threshold;
            }
            return false;
        }

        @Generated
        public LlamaResponseProbabilities(List<CompletionProbability> completionProbabilities, String content, boolean multimodal, int slotId, boolean stop) {
            this.completionProbabilities = completionProbabilities;
            this.content = content;
            this.multimodal = multimodal;
            this.slotId = slotId;
            this.stop = stop;
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public boolean isMultimodal() {
            return this.multimodal;
        }

        @Generated
        public int getSlotId() {
            return this.slotId;
        }

        @Generated
        public boolean isStop() {
            return this.stop;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LlamaResponseProbabilities)) {
                return false;
            }
            LlamaResponseProbabilities other = (LlamaResponseProbabilities)o;
            if (this.isMultimodal() != other.isMultimodal()) {
                return false;
            }
            if (this.getSlotId() != other.getSlotId()) {
                return false;
            }
            if (this.isStop() != other.isStop()) {
                return false;
            }
            List<CompletionProbability> this$completionProbabilities = this.getCompletionProbabilities();
            List<CompletionProbability> other$completionProbabilities = other.getCompletionProbabilities();
            if (this$completionProbabilities == null ? other$completionProbabilities != null : !((Object)this$completionProbabilities).equals(other$completionProbabilities)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMultimodal() ? 79 : 97);
            result = result * 59 + this.getSlotId();
            result = result * 59 + (this.isStop() ? 79 : 97);
            List<CompletionProbability> $completionProbabilities = this.getCompletionProbabilities();
            result = result * 59 + ($completionProbabilities == null ? 43 : ((Object)$completionProbabilities).hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AgentGenerativeModelClient.LlamaResponseProbabilities(completionProbabilities=" + this.getCompletionProbabilities() + ", content=" + this.getContent() + ", multimodal=" + this.isMultimodal() + ", slotId=" + this.getSlotId() + ", stop=" + this.isStop() + ")";
        }
    }

    public static final class TokenProbability {
        private final double prob;
        private final String tokStr;

        public double getProb() {
            return this.prob;
        }

        public String getTokStr() {
            return this.tokStr;
        }

        @Generated
        public TokenProbability(double prob, String tokStr) {
            this.prob = prob;
            this.tokStr = tokStr;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenProbability)) {
                return false;
            }
            TokenProbability other = (TokenProbability)o;
            if (Double.compare(this.getProb(), other.getProb()) != 0) {
                return false;
            }
            String this$tokStr = this.getTokStr();
            String other$tokStr = other.getTokStr();
            return !(this$tokStr == null ? other$tokStr != null : !this$tokStr.equals(other$tokStr));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $prob = Double.doubleToLongBits(this.getProb());
            result = result * 59 + (int)($prob >>> 32 ^ $prob);
            String $tokStr = this.getTokStr();
            result = result * 59 + ($tokStr == null ? 43 : $tokStr.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AgentGenerativeModelClient.TokenProbability(prob=" + this.getProb() + ", tokStr=" + this.getTokStr() + ")";
        }
    }

    public static final class CompletionProbability {
        private final String content;
        private final List<TokenProbability> probs;

        public String getContent() {
            return this.content;
        }

        public List<TokenProbability> getProbs() {
            return this.probs;
        }

        @Generated
        public CompletionProbability(String content, List<TokenProbability> probs) {
            this.content = content;
            this.probs = probs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompletionProbability)) {
                return false;
            }
            CompletionProbability other = (CompletionProbability)o;
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            List<TokenProbability> this$probs = this.getProbs();
            List<TokenProbability> other$probs = other.getProbs();
            return !(this$probs == null ? other$probs != null : !((Object)this$probs).equals(other$probs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            List<TokenProbability> $probs = this.getProbs();
            result = result * 59 + ($probs == null ? 43 : ((Object)$probs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AgentGenerativeModelClient.CompletionProbability(content=" + this.getContent() + ", probs=" + this.getProbs() + ")";
        }
    }
}

