/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;

public class SpellCheckerClient {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(3);
    private static final Path MODELS_DIR = Paths.get(System.getProperty("user.home") + "/.moderne/models", new String[0]);
    private final ObjectMapper mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    @Nullable
    private static SpellCheckerClient INSTANCE;

    public static synchronized SpellCheckerClient getInstance() {
        if (INSTANCE == null && (INSTANCE = new SpellCheckerClient()).checkForUpRequest() != 200) {
            INSTANCE.start();
        }
        return INSTANCE;
    }

    private void start() {
        Path pyLauncher = MODELS_DIR.resolve("spellcheck_comment_french.py");
        try {
            Files.copy(Objects.requireNonNull(SpellCheckerClient.class.getResourceAsStream("/spellcheck_comment_french.py")), pyLauncher, StandardCopyOption.REPLACE_EXISTING);
            StringWriter sw = new StringWriter();
            PrintWriter procOut = new PrintWriter(sw);
            String cmd = String.format("/usr/bin/python3 %s/spellcheck_comment_french.py", MODELS_DIR);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            EXECUTOR_SERVICE.submit(() -> {
                new BufferedReader(new InputStreamReader(proc.getInputStream())).lines().forEach(procOut::println);
                new BufferedReader(new InputStreamReader(proc.getErrorStream())).lines().forEach(procOut::println);
            });
            if (!this.checkForUp(proc)) {
                throw new IllegalStateException("Unable to start model daemon. Output of process is:\n" + sw);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkForUp(Process proc) {
        for (int i = 0; i < 60; ++i) {
            try {
                if (!proc.isAlive() && proc.exitValue() != 0) {
                    return false;
                }
                if (this.checkForUpRequest() == 200) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private int checkForUpRequest() {
        try {
            HttpResponse response = Unirest.head((String)"http://127.0.0.1:7866").asString();
            return response.getStatus();
        }
        catch (UnirestException e) {
            return 523;
        }
    }

    public String getCommentGradio(String text) {
        HttpUrlConnectionSender http = new HttpUrlConnectionSender(Duration.ofSeconds(20L), Duration.ofSeconds(30L));
        HttpSender.Response raw = null;
        try {
            raw = http.post("http://127.0.0.1:7866/run/predict").withContent("application/json", this.mapper.writeValueAsBytes((Object)new GradioRequest(new String[]{text}))).send();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (!raw.isSuccessful()) {
            throw new IllegalStateException("Unable to get embedding. HTTP " + raw.getClass());
        }
        String comment = null;
        try {
            comment = ((GradioResponse)this.mapper.readValue(raw.getBodyAsBytes(), GradioResponse.class)).getSpellCheck();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return comment;
    }

    static {
        if (!Files.exists(MODELS_DIR, new LinkOption[0]) && !MODELS_DIR.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to create models directory at " + MODELS_DIR);
        }
    }

    private static final class GradioRequest {
        private final Object[] data;

        @Generated
        public GradioRequest(Object[] data) {
            this.data = data;
        }

        @Generated
        public Object[] getData() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioRequest)) {
                return false;
            }
            GradioRequest other = (GradioRequest)o;
            return Arrays.deepEquals(this.getData(), other.getData());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            return result;
        }

        @Generated
        public String toString() {
            return "SpellCheckerClient.GradioRequest(data=" + Arrays.deepToString(this.getData()) + ")";
        }
    }

    private static final class GradioResponse {
        private final String[] data;

        public String getSpellCheck() {
            return this.data[0];
        }

        @Generated
        public GradioResponse(String[] data) {
            this.data = data;
        }

        @Generated
        public String[] getData() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioResponse)) {
                return false;
            }
            GradioResponse other = (GradioResponse)o;
            return Arrays.deepEquals(this.getData(), other.getData());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            return result;
        }

        @Generated
        public String toString() {
            return "SpellCheckerClient.GradioResponse(data=" + Arrays.deepToString(this.getData()) + ")";
        }
    }

    public static final class Comment {
        private final String t1;

        @Generated
        public Comment(String t1) {
            this.t1 = t1;
        }

        @Generated
        public String getT1() {
            return this.t1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            String this$t1 = this.getT1();
            String other$t1 = other.getT1();
            return !(this$t1 == null ? other$t1 != null : !this$t1.equals(other$t1));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $t1 = this.getT1();
            result = result * 59 + ($t1 == null ? 43 : $t1.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpellCheckerClient.Comment(t1=" + this.getT1() + ")";
        }
    }

    public static final class CommentFixed {
        private final String comment;
        private final List<Duration> commentTimings;

        @Generated
        public CommentFixed(String comment, List<Duration> commentTimings) {
            this.comment = comment;
            this.commentTimings = commentTimings;
        }

        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public List<Duration> getCommentTimings() {
            return this.commentTimings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommentFixed)) {
                return false;
            }
            CommentFixed other = (CommentFixed)o;
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            List<Duration> this$commentTimings = this.getCommentTimings();
            List<Duration> other$commentTimings = other.getCommentTimings();
            return !(this$commentTimings == null ? other$commentTimings != null : !((Object)this$commentTimings).equals(other$commentTimings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            List<Duration> $commentTimings = this.getCommentTimings();
            result = result * 59 + ($commentTimings == null ? 43 : ((Object)$commentTimings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpellCheckerClient.CommentFixed(comment=" + this.getComment() + ", commentTimings=" + this.getCommentTimings() + ")";
        }
    }
}

