/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.research;

import io.moderne.ai.AgentGenerativeModelClient;
import io.moderne.ai.EmbeddingModelClient;
import io.moderne.ai.RelatedModelClient;
import io.moderne.ai.table.CodeSearch;
import io.moderne.ai.table.EmbeddingPerformance;
import io.moderne.ai.table.GenerativeModelPerformance;
import io.moderne.ai.table.SuggestedMethodPatterns;
import io.moderne.ai.table.TopKMethodMatcher;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindCodeThatResembles
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Resembles", description="The text, either a natural language description or a code sample, that you are looking for.", example="HTTP request with Content-Type application/json")
    private final String resembles;
    @Option(displayName="Top-K methods", description="Since AI based matching has a higher latency than rules based matching, we do a first pass to find the top k methods using embeddings. To narrow the scope, you can specify the top k methods as method filters.", example="5")
    private final int k;
    private final transient CodeSearch codeSearchTable = new CodeSearch((Recipe)this);
    private final transient TopKMethodMatcher topKTable = new TopKMethodMatcher((Recipe)this);
    private final transient EmbeddingPerformance embeddingPerformance = new EmbeddingPerformance((Recipe)this);
    private final transient GenerativeModelPerformance generativeModelPerformance = new GenerativeModelPerformance((Recipe)this);
    private final transient SuggestedMethodPatterns suggestedMethodPatternsTable = new SuggestedMethodPatterns((Recipe)this);

    public String getDisplayName() {
        return "Find method invocations that resemble a pattern";
    }

    public String getDescription() {
        return "This recipe uses two phase AI approach to find a method invocation that resembles a search string.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(this.k);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            private String extractTypeName(String fullyQualifiedTypeName) {
                String[] parts = fullyQualifiedTypeName.split("(<|>)");
                String outer = parts[0];
                String inner = parts.length > 1 ? parts[1] : "";
                outer = outer.substring(outer.lastIndexOf(46) + 1);
                inner = inner.substring(inner.lastIndexOf(46) + 1);
                return inner.isEmpty() ? outer : outer + "<" + inner + ">";
            }

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                cu.getTypesInUse().getUsedMethods().forEach(type -> {
                    StringBuilder methodSignatureBuilder = new StringBuilder();
                    StringBuilder methodPatternBuilder = new StringBuilder();
                    String methodSignature = methodSignatureBuilder.append(this.extractTypeName(Optional.ofNullable(type.getReturnType()).map(Object::toString).orElse(""))).append(" ").append(type.getName()).toString();
                    methodSignatureBuilder.setLength(0);
                    for (int i = 0; i < type.getParameterTypes().size(); ++i) {
                        String typeName = this.extractTypeName(((JavaType)type.getParameterTypes().get(i)).toString());
                        String paramName = (String)type.getParameterNames().get(i);
                        methodSignatureBuilder.append(typeName).append(" ").append(paramName);
                        if (i >= type.getParameterTypes().size() - 1) continue;
                        methodSignatureBuilder.append(", ");
                    }
                    methodSignature = methodSignature + "(" + methodSignatureBuilder.toString() + ")";
                    methodPatternBuilder.setLength(0);
                    String methodPattern = methodPatternBuilder.append(Optional.ofNullable(type.getDeclaringType()).map(Object::toString).orElse("")).append(" ").append(type.getName()).append("(..)").toString();
                    acc.add(methodSignature, methodPattern, FindCodeThatResembles.this.resembles);
                });
                return super.visitCompilationUnit(cu, (Object)ctx);
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        acc.populateTopK();
        final List<MethodMatcher> methodMatchers = acc.getTopMethodPatterns();
        ArrayList<UsesMethod> preconditions = new ArrayList<UsesMethod>(methodMatchers.size());
        for (MethodMatcher m : methodMatchers) {
            preconditions.add(new UsesMethod(m));
        }
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])preconditions.toArray(new TreeVisitor[0])), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile instanceof J.CompilationUnit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.getCursor().putMessage("countEmbedding", (Object)new AtomicInteger());
                this.getCursor().putMessage("maxEmbedding", (Object)new AtomicLong());
                this.getCursor().putMessage("histogramEmbedding", (Object)new EmbeddingPerformance.Histogram());
                this.getCursor().putMessage("countGenerative", (Object)new AtomicInteger());
                this.getCursor().putMessage("maxGenerative", (Object)new AtomicLong());
                this.getCursor().putMessage("histogramGenerative", (Object)new GenerativeModelPerformance.Histogram());
                try {
                    J.CompilationUnit compilationUnit = super.visitCompilationUnit(cu, (Object)ctx);
                    return compilationUnit;
                }
                finally {
                    if (((AtomicInteger)this.getCursor().getMessage("countEmbedding", (Object)new AtomicInteger())).get() > 0) {
                        Duration embeddingMax = Duration.ofNanos(Objects.requireNonNull((AtomicLong)this.getCursor().getMessage("maxEmbedding")).get());
                        FindCodeThatResembles.this.embeddingPerformance.insertRow(ctx, new EmbeddingPerformance.Row(cu.getSourcePath().toString(), Objects.requireNonNull((AtomicInteger)this.getCursor().getMessage("countEmbedding")).get(), Objects.requireNonNull((EmbeddingPerformance.Histogram)this.getCursor().getMessage("histogramEmbedding")).getBuckets(), embeddingMax));
                    }
                    if (((AtomicInteger)this.getCursor().getMessage("countGenerative", (Object)new AtomicInteger())).get() > 0) {
                        Duration generativeMax = Duration.ofNanos(Objects.requireNonNull((AtomicLong)this.getCursor().getMessage("maxGenerative")).get());
                        FindCodeThatResembles.this.generativeModelPerformance.insertRow(ctx, new GenerativeModelPerformance.Row(cu.getSourcePath().toString(), Objects.requireNonNull((AtomicInteger)this.getCursor().getMessage("countGenerative")).get(), Objects.requireNonNull((GenerativeModelPerformance.Histogram)this.getCursor().getMessage("histogramGenerative")).getBuckets(), generativeMax));
                    }
                }
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (!acc.populatedTopKDataTable.booleanValue()) {
                    List<MethodSignatureWithDistance> methodMatchersDistance = acc.getTopMethodSignatureWithDistances();
                    for (MethodSignatureWithDistance methodSignatureWithDistance : methodMatchersDistance) {
                        FindCodeThatResembles.this.topKTable.insertRow(ctx, new TopKMethodMatcher.Row(methodSignatureWithDistance.getMethodPattern(), methodSignatureWithDistance.getMethodSignature(), methodSignatureWithDistance.getDistance(), FindCodeThatResembles.this.resembles));
                    }
                    acc.setPopulatedTopKDataTable(true);
                }
                boolean matches = false;
                String methodPattern = "";
                for (Object m : methodMatchers) {
                    if (!m.matches((MethodCall)method)) continue;
                    matches = true;
                    methodPattern = m.toString();
                    break;
                }
                if (!matches) {
                    return super.visitMethodInvocation(method, (Object)ctx);
                }
                RelatedModelClient.Relatedness relatedness = RelatedModelClient.getInstance().getRelatedness(FindCodeThatResembles.this.resembles, method.printTrimmed(this.getCursor()));
                for (Duration timing : relatedness.getEmbeddingTimings()) {
                    Objects.requireNonNull((AtomicInteger)this.getCursor().getNearestMessage("countEmbedding")).incrementAndGet();
                    Objects.requireNonNull((EmbeddingPerformance.Histogram)this.getCursor().getNearestMessage("histogramEmbedding")).add(timing);
                    AtomicLong max = (AtomicLong)this.getCursor().getNearestMessage("maxEmbedding");
                    if (Objects.requireNonNull(max).get() >= timing.toNanos()) continue;
                    max.set(timing.toNanos());
                }
                int resultEmbeddingModels = relatedness.isRelated();
                boolean calledGenerativeModel = false;
                boolean resultGenerativeModel = false;
                if (resultEmbeddingModels == 0) {
                    AgentGenerativeModelClient.TimedRelatedness resultGenerativeModelTimed = AgentGenerativeModelClient.getInstance().isRelatedTiming(FindCodeThatResembles.this.resembles, method.printTrimmed(this.getCursor()), 0.5932);
                    resultGenerativeModel = resultGenerativeModelTimed.isRelated();
                    calledGenerativeModel = true;
                    Duration timing = resultGenerativeModelTimed.getDuration();
                    Objects.requireNonNull((AtomicInteger)this.getCursor().getNearestMessage("countGenerative")).incrementAndGet();
                    Objects.requireNonNull((GenerativeModelPerformance.Histogram)this.getCursor().getNearestMessage("histogramGenerative")).add(timing);
                    AtomicLong max = (AtomicLong)this.getCursor().getNearestMessage("maxGenerative");
                    if (Objects.requireNonNull(max).get() < timing.toNanos()) {
                        max.set(timing.toNanos());
                    }
                }
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                String source = javaSourceFile.getSourcePath().toString();
                FindCodeThatResembles.this.codeSearchTable.insertRow(ctx, new CodeSearch.Row(source, method.printTrimmed(this.getCursor()), FindCodeThatResembles.this.resembles, resultEmbeddingModels, calledGenerativeModel, resultGenerativeModel));
                if (resultGenerativeModel || resultEmbeddingModels == 1) {
                    FindCodeThatResembles.this.suggestedMethodPatternsTable.insertRow(ctx, new SuggestedMethodPatterns.Row(method.printTrimmed(this.getCursor()), methodPattern, FindCodeThatResembles.this.resembles));
                }
                if (calledGenerativeModel) {
                    return resultGenerativeModel ? (J.MethodInvocation)SearchResult.found((Tree)method) : super.visitMethodInvocation(method, (Object)ctx);
                }
                return resultEmbeddingModels == 1 ? (J.MethodInvocation)SearchResult.found((Tree)method) : super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public FindCodeThatResembles(String resembles, int k) {
        this.resembles = resembles;
        this.k = k;
    }

    @Generated
    public String getResembles() {
        return this.resembles;
    }

    @Generated
    public int getK() {
        return this.k;
    }

    @Generated
    public CodeSearch getCodeSearchTable() {
        return this.codeSearchTable;
    }

    @Generated
    public TopKMethodMatcher getTopKTable() {
        return this.topKTable;
    }

    @Generated
    public EmbeddingPerformance getEmbeddingPerformance() {
        return this.embeddingPerformance;
    }

    @Generated
    public GenerativeModelPerformance getGenerativeModelPerformance() {
        return this.generativeModelPerformance;
    }

    @Generated
    public SuggestedMethodPatterns getSuggestedMethodPatternsTable() {
        return this.suggestedMethodPatternsTable;
    }

    @Generated
    public String toString() {
        return "FindCodeThatResembles(resembles=" + this.getResembles() + ", k=" + this.getK() + ", codeSearchTable=" + (Object)((Object)this.getCodeSearchTable()) + ", topKTable=" + (Object)((Object)this.getTopKTable()) + ", embeddingPerformance=" + (Object)((Object)this.getEmbeddingPerformance()) + ", generativeModelPerformance=" + (Object)((Object)this.getGenerativeModelPerformance()) + ", suggestedMethodPatternsTable=" + (Object)((Object)this.getSuggestedMethodPatternsTable()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCodeThatResembles)) {
            return false;
        }
        FindCodeThatResembles other = (FindCodeThatResembles)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getK() != other.getK()) {
            return false;
        }
        String this$resembles = this.getResembles();
        String other$resembles = other.getResembles();
        return !(this$resembles == null ? other$resembles != null : !this$resembles.equals(other$resembles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindCodeThatResembles;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getK();
        String $resembles = this.getResembles();
        result = result * 59 + ($resembles == null ? 43 : $resembles.hashCode());
        return result;
    }

    public static final class Accumulator {
        private @Nullable Boolean populatedTopKDataTable = false;
        private final int k;
        private final PriorityQueue<MethodSignatureWithDistance> methodSignaturesQueue = new PriorityQueue<MethodSignatureWithDistance>(Comparator.comparingDouble(MethodSignatureWithDistance::getDistance));
        private final EmbeddingModelClient embeddingModelClient = EmbeddingModelClient.getInstance();
        private final HashSet<String> methodPatternsSet = new HashSet();
        private @Nullable List<MethodMatcher> topMethodPatterns;
        private @Nullable List<MethodSignatureWithDistance> topMethodSignatureWithDistances;

        public void add(String methodSignature, String methodPattern, String resembles) {
            if (this.methodPatternsSet.contains(methodPattern)) {
                return;
            }
            MethodSignatureWithDistance methodSignatureWithDistance = new MethodSignatureWithDistance(methodSignature, methodPattern, (float)this.embeddingModelClient.getDistance(resembles, methodSignature));
            this.methodSignaturesQueue.add(methodSignatureWithDistance);
            this.methodPatternsSet.add(methodPattern);
        }

        public List<MethodSignatureWithDistance> getTopMethodSignatureWithDistances() {
            return this.topMethodSignatureWithDistances;
        }

        public List<MethodMatcher> getTopMethodPatterns() {
            return this.topMethodPatterns;
        }

        public List<MethodMatcher> populateTopK() {
            if (this.topMethodPatterns != null) {
                return null;
            }
            this.topMethodPatterns = new ArrayList<MethodMatcher>(this.k);
            this.topMethodSignatureWithDistances = new ArrayList<MethodSignatureWithDistance>(this.k);
            for (int i = 0; i < this.k && !this.methodSignaturesQueue.isEmpty(); ++i) {
                MethodSignatureWithDistance currentMethod = this.methodSignaturesQueue.poll();
                String inputString = currentMethod.getMethodPattern();
                if (!inputString.contains("<constructor>")) {
                    inputString = inputString.replaceAll("<[^>]*>", "");
                }
                this.topMethodPatterns.add(new MethodMatcher(inputString, true));
                this.topMethodSignatureWithDistances.add(currentMethod);
            }
            return this.topMethodPatterns;
        }

        public void setPopulatedTopKDataTable(boolean b) {
            this.populatedTopKDataTable = b;
        }

        @Generated
        public @Nullable Boolean getPopulatedTopKDataTable() {
            return this.populatedTopKDataTable;
        }

        @Generated
        public int getK() {
            return this.k;
        }

        @Generated
        public PriorityQueue<MethodSignatureWithDistance> getMethodSignaturesQueue() {
            return this.methodSignaturesQueue;
        }

        @Generated
        public EmbeddingModelClient getEmbeddingModelClient() {
            return this.embeddingModelClient;
        }

        @Generated
        public HashSet<String> getMethodPatternsSet() {
            return this.methodPatternsSet;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (this.getK() != other.getK()) {
                return false;
            }
            Boolean this$populatedTopKDataTable = this.getPopulatedTopKDataTable();
            Boolean other$populatedTopKDataTable = other.getPopulatedTopKDataTable();
            if (this$populatedTopKDataTable == null ? other$populatedTopKDataTable != null : !((Object)this$populatedTopKDataTable).equals(other$populatedTopKDataTable)) {
                return false;
            }
            PriorityQueue<MethodSignatureWithDistance> this$methodSignaturesQueue = this.getMethodSignaturesQueue();
            PriorityQueue<MethodSignatureWithDistance> other$methodSignaturesQueue = other.getMethodSignaturesQueue();
            if (this$methodSignaturesQueue == null ? other$methodSignaturesQueue != null : !this$methodSignaturesQueue.equals(other$methodSignaturesQueue)) {
                return false;
            }
            EmbeddingModelClient this$embeddingModelClient = this.getEmbeddingModelClient();
            EmbeddingModelClient other$embeddingModelClient = other.getEmbeddingModelClient();
            if (this$embeddingModelClient == null ? other$embeddingModelClient != null : !this$embeddingModelClient.equals(other$embeddingModelClient)) {
                return false;
            }
            HashSet<String> this$methodPatternsSet = this.getMethodPatternsSet();
            HashSet<String> other$methodPatternsSet = other.getMethodPatternsSet();
            if (this$methodPatternsSet == null ? other$methodPatternsSet != null : !((Object)this$methodPatternsSet).equals(other$methodPatternsSet)) {
                return false;
            }
            List<MethodMatcher> this$topMethodPatterns = this.getTopMethodPatterns();
            List<MethodMatcher> other$topMethodPatterns = other.getTopMethodPatterns();
            if (this$topMethodPatterns == null ? other$topMethodPatterns != null : !((Object)this$topMethodPatterns).equals(other$topMethodPatterns)) {
                return false;
            }
            List<MethodSignatureWithDistance> this$topMethodSignatureWithDistances = this.getTopMethodSignatureWithDistances();
            List<MethodSignatureWithDistance> other$topMethodSignatureWithDistances = other.getTopMethodSignatureWithDistances();
            return !(this$topMethodSignatureWithDistances == null ? other$topMethodSignatureWithDistances != null : !((Object)this$topMethodSignatureWithDistances).equals(other$topMethodSignatureWithDistances));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getK();
            Boolean $populatedTopKDataTable = this.getPopulatedTopKDataTable();
            result = result * 59 + ($populatedTopKDataTable == null ? 43 : ((Object)$populatedTopKDataTable).hashCode());
            PriorityQueue<MethodSignatureWithDistance> $methodSignaturesQueue = this.getMethodSignaturesQueue();
            result = result * 59 + ($methodSignaturesQueue == null ? 43 : $methodSignaturesQueue.hashCode());
            EmbeddingModelClient $embeddingModelClient = this.getEmbeddingModelClient();
            result = result * 59 + ($embeddingModelClient == null ? 43 : $embeddingModelClient.hashCode());
            HashSet<String> $methodPatternsSet = this.getMethodPatternsSet();
            result = result * 59 + ($methodPatternsSet == null ? 43 : ((Object)$methodPatternsSet).hashCode());
            List<MethodMatcher> $topMethodPatterns = this.getTopMethodPatterns();
            result = result * 59 + ($topMethodPatterns == null ? 43 : ((Object)$topMethodPatterns).hashCode());
            List<MethodSignatureWithDistance> $topMethodSignatureWithDistances = this.getTopMethodSignatureWithDistances();
            result = result * 59 + ($topMethodSignatureWithDistances == null ? 43 : ((Object)$topMethodSignatureWithDistances).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FindCodeThatResembles.Accumulator(populatedTopKDataTable=" + this.getPopulatedTopKDataTable() + ", k=" + this.getK() + ", methodSignaturesQueue=" + this.getMethodSignaturesQueue() + ", embeddingModelClient=" + this.getEmbeddingModelClient() + ", methodPatternsSet=" + this.getMethodPatternsSet() + ", topMethodPatterns=" + this.getTopMethodPatterns() + ", topMethodSignatureWithDistances=" + this.getTopMethodSignatureWithDistances() + ")";
        }

        @Generated
        public Accumulator(int k) {
            this.k = k;
        }
    }

    private static final class MethodSignatureWithDistance {
        private final String methodSignature;
        private final String methodPattern;
        private final double distance;

        @Generated
        public MethodSignatureWithDistance(String methodSignature, String methodPattern, double distance) {
            this.methodSignature = methodSignature;
            this.methodPattern = methodPattern;
            this.distance = distance;
        }

        @Generated
        public String getMethodSignature() {
            return this.methodSignature;
        }

        @Generated
        public String getMethodPattern() {
            return this.methodPattern;
        }

        @Generated
        public double getDistance() {
            return this.distance;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodSignatureWithDistance)) {
                return false;
            }
            MethodSignatureWithDistance other = (MethodSignatureWithDistance)o;
            if (Double.compare(this.getDistance(), other.getDistance()) != 0) {
                return false;
            }
            String this$methodSignature = this.getMethodSignature();
            String other$methodSignature = other.getMethodSignature();
            if (this$methodSignature == null ? other$methodSignature != null : !this$methodSignature.equals(other$methodSignature)) {
                return false;
            }
            String this$methodPattern = this.getMethodPattern();
            String other$methodPattern = other.getMethodPattern();
            return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $distance = Double.doubleToLongBits(this.getDistance());
            result = result * 59 + (int)($distance >>> 32 ^ $distance);
            String $methodSignature = this.getMethodSignature();
            result = result * 59 + ($methodSignature == null ? 43 : $methodSignature.hashCode());
            String $methodPattern = this.getMethodPattern();
            result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FindCodeThatResembles.MethodSignatureWithDistance(methodSignature=" + this.getMethodSignature() + ", methodPattern=" + this.getMethodPattern() + ", distance=" + this.getDistance() + ")";
        }
    }
}

