/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.openrewrite.internal.lang.Nullable;

public class LanguageDetectorModelClient {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(3);
    private static final Path MODELS_DIR = Paths.get(System.getProperty("user.home") + "/.moderne/models", new String[0]);
    @Nullable
    private static LanguageDetectorModelClient INSTANCE;
    private final Map<Comment, String> languageCache = Collections.synchronizedMap(new LinkedHashMap<Comment, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Comment, String> eldest) {
            return this.size() > 1000;
        }
    });

    public static synchronized LanguageDetectorModelClient getInstance() {
        if (INSTANCE == null && (INSTANCE = new LanguageDetectorModelClient()).checkForUpRequest() != 200) {
            String cmd = String.format("/usr/bin/python3 'import gradio\ngradio.'", MODELS_DIR);
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            INSTANCE.start();
        }
        return INSTANCE;
    }

    private void start() {
        Path pyLauncher = MODELS_DIR.resolve("get_language.py");
        try {
            Files.copy(Objects.requireNonNull(LanguageDetectorModelClient.class.getResourceAsStream("/get_language.py")), pyLauncher, StandardCopyOption.REPLACE_EXISTING);
            StringWriter sw = new StringWriter();
            PrintWriter procOut = new PrintWriter(sw);
            String cmd = String.format("/usr/bin/python3 %s/get_language.py", MODELS_DIR);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            EXECUTOR_SERVICE.submit(() -> {
                new BufferedReader(new InputStreamReader(proc.getInputStream())).lines().forEach(procOut::println);
                new BufferedReader(new InputStreamReader(proc.getErrorStream())).lines().forEach(procOut::println);
            });
            if (!this.checkForUp(proc)) {
                throw new IllegalStateException("Unable to start model daemon. Output of process is:\n" + sw);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkForUp(Process proc) {
        for (int i = 0; i < 60; ++i) {
            try {
                if (!proc.isAlive() && proc.exitValue() != 0) {
                    return false;
                }
                if (this.checkForUpRequest() == 200) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private int checkForUpRequest() {
        try {
            HttpResponse response = Unirest.head((String)"http://127.0.0.1:7861").asString();
            return response.getStatus();
        }
        catch (UnirestException e) {
            return 523;
        }
    }

    public Language getLanguage(String t1) {
        ArrayList<Duration> timings = new ArrayList<Duration>(2);
        Comment comment = new Comment(t1);
        String b1 = this.languageCache.computeIfAbsent(comment, this.timeLanguage(timings));
        return new Language(b1, timings);
    }

    private Function<Comment, String> timeLanguage(List<Duration> timings) {
        return t -> {
            long start = System.nanoTime();
            String b = this.getLanguageGradio(((Comment)t).t1);
            if (timings.isEmpty()) {
                timings.add(Duration.ofNanos(System.nanoTime() - start));
            }
            return b;
        };
    }

    public String getLanguageGradio(String s1) {
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)"http://127.0.0.1:7861/run/predict").header("Content-Type", "application/json")).body((Object)new GradioRequest(new Object[]{s1})).asObject(GradioResponse.class);
        if (!response.isSuccess()) {
            throw new IllegalStateException("Unable to get language. HTTP " + response.getStatus());
        }
        return ((GradioResponse)response.getBody()).getLanguage();
    }

    static {
        if (!Files.exists(MODELS_DIR, new LinkOption[0]) && !MODELS_DIR.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to create models directory at " + MODELS_DIR);
        }
    }

    public static final class Comment {
        private final String t1;

        public Comment(String t1) {
            this.t1 = t1;
        }

        public String getT1() {
            return this.t1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            String this$t1 = this.getT1();
            String other$t1 = other.getT1();
            return !(this$t1 == null ? other$t1 != null : !this$t1.equals(other$t1));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $t1 = this.getT1();
            result = result * 59 + ($t1 == null ? 43 : $t1.hashCode());
            return result;
        }

        public String toString() {
            return "LanguageDetectorModelClient.Comment(t1=" + this.getT1() + ")";
        }
    }

    public static final class Language {
        private final String language;
        private final List<Duration> LanguageTimings;

        public Language(String language, List<Duration> LanguageTimings) {
            this.language = language;
            this.LanguageTimings = LanguageTimings;
        }

        public String getLanguage() {
            return this.language;
        }

        public List<Duration> getLanguageTimings() {
            return this.LanguageTimings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Language)) {
                return false;
            }
            Language other = (Language)o;
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            List<Duration> this$LanguageTimings = this.getLanguageTimings();
            List<Duration> other$LanguageTimings = other.getLanguageTimings();
            return !(this$LanguageTimings == null ? other$LanguageTimings != null : !((Object)this$LanguageTimings).equals(other$LanguageTimings));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            List<Duration> $LanguageTimings = this.getLanguageTimings();
            result = result * 59 + ($LanguageTimings == null ? 43 : ((Object)$LanguageTimings).hashCode());
            return result;
        }

        public String toString() {
            return "LanguageDetectorModelClient.Language(language=" + this.getLanguage() + ", LanguageTimings=" + this.getLanguageTimings() + ")";
        }
    }

    private static final class GradioRequest {
        private final Object[] data;

        public GradioRequest(Object[] data) {
            this.data = data;
        }

        public Object[] getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioRequest)) {
                return false;
            }
            GradioRequest other = (GradioRequest)o;
            return Arrays.deepEquals(this.getData(), other.getData());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            return result;
        }

        public String toString() {
            return "LanguageDetectorModelClient.GradioRequest(data=" + Arrays.deepToString(this.getData()) + ")";
        }
    }

    private static final class GradioResponse {
        private final String[] data;

        public String getLanguage() {
            return this.data[0];
        }

        public GradioResponse(String[] data) {
            this.data = data;
        }

        public String[] getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioResponse)) {
                return false;
            }
            GradioResponse other = (GradioResponse)o;
            return Arrays.deepEquals(this.getData(), other.getData());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            return result;
        }

        public String toString() {
            return "LanguageDetectorModelClient.GradioResponse(data=" + Arrays.deepToString(this.getData()) + ")";
        }
    }
}

