#
# Moderne Proprietary. Only for use by Moderne customers under the terms of a commercial contract.
#


#initialize models
from infinity_emb import EngineArgs, AsyncEmbeddingEngine
from infinity_emb import create_server
import uvicorn
import logging
from fastapi.responses import JSONResponse

logging.getLogger("infinity_emb").setLevel(logging.ERROR)

engine_args = EngineArgs(
    model_name_or_path="michaelfeil/bge-small-en-v1.5",
    device="cpu",
    engine="optimum",
    served_model_name="bge-small",
    compile=True,
    batch_size=1
)

fastapi_app = create_server(engine_args_list=[engine_args])
@fastapi_app.head("/embeddings")
def read_root_head():
    return JSONResponse({"message": "Infinity embedding is running"})

uvicorn.run(fastapi_app, host="127.0.0.1", port=7860)
