/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.research;

import io.moderne.ai.AgentGenerativeModelClient;
import io.moderne.ai.ClusteringClient;
import io.moderne.ai.EmbeddingModelClient;
import io.moderne.ai.table.Recommendations;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public final class GetRecommendations
extends ScanningRecipe<Accumulator> {
    @Option(displayName="random sampling", description="Do random sampling or use clusters based on embeddings to sample.")
    private final @Nullable Boolean randomSampling;
    @Option(displayName="number of centers to sample", description="Number of diverse centers to sample if you don't do random sampling per repository.", example="3", required=false)
    private final int numberOfCenters;
    private final transient Recommendations recommendationsTable = new Recommendations((Recipe)this);
    private static final Random random = new Random(13L);

    public String getDisplayName() {
        return "Get recommendations";
    }

    public String getDescription() {
        return "This recipe calls an AI model to get recommendations for modernizing the code base by looking at a sample of method declarations.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                String methodName = md.getSimpleName();
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                String source = javaSourceFile.getSourcePath().toString();
                acc.addMethodToSample(md.printTrimmed(this.getCursor()), methodName, source);
                return md;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                boolean randomSampling;
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                boolean isMethodToSample = false;
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                String source = javaSourceFile.getSourcePath().toString();
                boolean bl = randomSampling = GetRecommendations.this.getRandomSampling() != null ? GetRecommendations.this.getRandomSampling() : false;
                if (randomSampling) {
                    isMethodToSample = random.nextInt(200) <= 1;
                } else {
                    for (Method methodToSample : acc.getMethodsToSample(GetRecommendations.this.numberOfCenters)) {
                        if (!methodToSample.file.equals(source) || !methodToSample.name.equals(md.getSimpleName()) || !methodToSample.method.equals(md.printTrimmed(this.getCursor()))) continue;
                        isMethodToSample = true;
                        break;
                    }
                }
                if (isMethodToSample) {
                    long time = System.nanoTime();
                    ArrayList<String> recommendations = AgentGenerativeModelClient.getInstance().getRecommendations(md.printTrimmed(this.getCursor()));
                    List recommendationsQuoted = recommendations.stream().map(element -> "\"" + element + "\"").collect(Collectors.toList());
                    String recommendationsAsString = "[" + String.join((CharSequence)", ", recommendationsQuoted) + "]";
                    int tokenSize = (int)((double)md.printTrimmed(this.getCursor()).length() / 3.5 + (double)((Object)recommendations).toString().length() / 3.5);
                    double elapsedTime = (double)(System.nanoTime() - time) / 1.0E9;
                    GetRecommendations.this.recommendationsTable.insertRow(ctx, new Recommendations.Row(md.getSimpleName(), elapsedTime, tokenSize, recommendationsAsString));
                }
                return md;
            }
        };
    }

    @Generated
    public GetRecommendations(@Nullable Boolean randomSampling, int numberOfCenters) {
        this.randomSampling = randomSampling;
        this.numberOfCenters = numberOfCenters;
    }

    @Generated
    public @Nullable Boolean getRandomSampling() {
        return this.randomSampling;
    }

    @Generated
    public int getNumberOfCenters() {
        return this.numberOfCenters;
    }

    @Generated
    public Recommendations getRecommendationsTable() {
        return this.recommendationsTable;
    }

    @Generated
    public String toString() {
        return "GetRecommendations(randomSampling=" + this.getRandomSampling() + ", numberOfCenters=" + this.getNumberOfCenters() + ", recommendationsTable=" + (Object)((Object)this.getRecommendationsTable()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetRecommendations)) {
            return false;
        }
        GetRecommendations other = (GetRecommendations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getNumberOfCenters() != other.getNumberOfCenters()) {
            return false;
        }
        Boolean this$randomSampling = this.getRandomSampling();
        Boolean other$randomSampling = other.getRandomSampling();
        return !(this$randomSampling == null ? other$randomSampling != null : !((Object)this$randomSampling).equals(other$randomSampling));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetRecommendations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberOfCenters();
        Boolean $randomSampling = this.getRandomSampling();
        result = result * 59 + ($randomSampling == null ? 43 : ((Object)$randomSampling).hashCode());
        return result;
    }

    public class Accumulator {
        List<Method> methods = new ArrayList<Method>();
        List<float[]> embeddings = new ArrayList<float[]>();
        int @Nullable [] centers;

        public int[] getCenters(int numberOfCenters) {
            if (this.centers == null) {
                this.centers = ClusteringClient.getInstance().getCenters(this.embeddings, numberOfCenters);
            }
            return this.centers;
        }

        public Method[] getMethodsToSample(int numberOfCenters) {
            int[] centersIndex = this.getCenters(numberOfCenters);
            Method[] methodsToSample = new Method[centersIndex.length];
            for (int i = 0; i < this.getCenters(numberOfCenters).length; ++i) {
                methodsToSample[i] = this.methods.get(centersIndex[i]);
            }
            return methodsToSample;
        }

        public void addMethodToSample(String method, String methodName, String file) {
            this.methods.add(new Method(method, methodName, file));
            this.embeddings.add(EmbeddingModelClient.getInstance().getEmbedding(method));
        }
    }

    public final class Method {
        private final String method;
        private final String name;
        private final String file;

        @Generated
        public Method(String method, String name, String file) {
            this.method = method;
            this.name = name;
            this.file = file;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getFile() {
            return this.file;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Method)) {
                return false;
            }
            Method other = (Method)o;
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            return !(this$file == null ? other$file != null : !this$file.equals(other$file));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GetRecommendations.Method(method=" + this.getMethod() + ", name=" + this.getName() + ", file=" + this.getFile() + ")";
        }
    }
}

