/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import io.moderne.ai.LanguageDetectorModelClient;
import io.moderne.ai.SpellCheckerClient;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.properties.PropertiesIsoVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class SpellCheckCommentsInFrench
extends Recipe {
    public String getDisplayName() {
        return "Fix mis-encoded comments in French";
    }

    public String getDescription() {
        return "Use spellchecker to fix mis-encoded French comments in comments, JavaDocs, properties or XML files. Mis-encoded comments will contain either '?' or '\ufffd'.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JavaIsoVisitor<ExecutionContext> javaVisitor = SpellCheckCommentsInFrench.javaVisitor();
        final XmlIsoVisitor<ExecutionContext> xmlVisitor = SpellCheckCommentsInFrench.mavenVisitor();
        final PropertiesIsoVisitor<ExecutionContext> propertiesVisitor = SpellCheckCommentsInFrench.propertiesVisitor();
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                tree = javaVisitor.visit(tree, (Object)ctx);
                tree = xmlVisitor.visit(tree, (Object)ctx);
                return propertiesVisitor.visit(tree, (Object)ctx);
            }
        };
    }

    private static JavaIsoVisitor<ExecutionContext> javaVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
                return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                    public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext ctx) {
                        Javadoc.DocComment dc = (Javadoc.DocComment)super.visitDocComment(javadoc, (Object)ctx);
                        return dc.withBody(ListUtils.map((List)dc.getBody(), docLine -> {
                            String fixedComment;
                            String commentText;
                            if (docLine instanceof Javadoc.Text && !(commentText = ((Javadoc.Text)docLine).getText()).trim().isEmpty() && "fr".equals(LanguageDetectorModelClient.getInstance().getLanguage(commentText).getLanguage()) && !(fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText)).equals(commentText)) {
                                docLine = ((Javadoc.Text)docLine).withText(fixedComment);
                            }
                            return docLine;
                        }));
                    }
                };
            }

            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                Space s = super.visitSpace(space, loc, (Object)ctx);
                return s.withComments(ListUtils.map((List)s.getComments(), c -> {
                    String fixedComment;
                    TextComment tc;
                    String commentText;
                    if (c instanceof TextComment && !(commentText = (tc = (TextComment)c).getText()).isEmpty() && "fr".equals(LanguageDetectorModelClient.getInstance().getLanguage(commentText).getLanguage()) && !(fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText)).equals(commentText)) {
                        return tc.withText(fixedComment);
                    }
                    return c;
                }));
            }
        };
    }

    private static XmlIsoVisitor<ExecutionContext> mavenVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            public Xml.Comment visitComment(Xml.Comment comment, ExecutionContext ctx) {
                String fixedComment;
                String commentText = comment.getText();
                if (!commentText.isEmpty() && "fr".equals(LanguageDetectorModelClient.getInstance().getLanguage(commentText).getLanguage()) && !(fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText)).equals(commentText)) {
                    return comment.withText(fixedComment);
                }
                return comment;
            }
        };
    }

    private static PropertiesIsoVisitor<ExecutionContext> propertiesVisitor() {
        return new PropertiesIsoVisitor<ExecutionContext>(){

            public Properties.Comment visitComment(Properties.Comment comment, ExecutionContext ctx) {
                String fixedComment;
                String commentText = comment.getMessage();
                if (!commentText.isEmpty() && "fr".equals(LanguageDetectorModelClient.getInstance().getLanguage(commentText).getLanguage()) && !(fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText)).equals(commentText)) {
                    return comment.withMessage(fixedComment);
                }
                return comment;
            }
        };
    }

    @Generated
    public SpellCheckCommentsInFrench() {
    }

    @Generated
    public String toString() {
        return "SpellCheckCommentsInFrench()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpellCheckCommentsInFrench)) {
            return false;
        }
        SpellCheckCommentsInFrench other = (SpellCheckCommentsInFrench)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpellCheckCommentsInFrench;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

