#
# Copyright 2025 the original author or authors.
#
# Moderne Proprietary. Only for use by Moderne customers under the terms of a commercial contract.
#

import os
os.environ["XDG_CACHE_HOME"]="/HF_CACHE"
os.environ["HF_HOME"]="/HF_CACHE/huggingface"
os.environ["HUGGINGFACE_HUB_CACHE"]="/HF_CACHE/huggingface/hub"
os.environ["TRANSFORMERS_CACHE"]="/HF_CACHE/huggingface"
from transformers import logging, pipeline # 4.29.2
import gradio as gr # 3.23.0
logging.set_verbosity_error()

pipe = pipeline("text-classification", model="papluca/xlm-roberta-base-language-detection")
tokenizer_kwargs = {'truncation':True, 'max_length':512}

def get_language(comment):
    lang = pipe(comment, **tokenizer_kwargs)[0]
    confidence = lang["score"]
    lang = lang["label"]
    if confidence <= 0.5:
        return "unknown"
    return lang

gr.Interface(fn=get_language, inputs=["text"], outputs="text").launch(server_port=7861)
