/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.table;

import java.util.Arrays;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class Embeddings
extends DataTable<Row> {
    public Embeddings(Recipe recipe) {
        super(recipe, "Embeddings", "Collects the embeddings for either each classes or methods.");
    }

    public static final class Row {
        @Column(displayName="Name", description="Name of the class or method")
        private final String name;
        @Column(displayName="Embedding", description="The embedding for the code snippet")
        private final float[] embedding;

        public Row(String name, float[] embedding) {
            this.name = name;
            this.embedding = embedding;
        }

        public String getName() {
            return this.name;
        }

        public float[] getEmbedding() {
            return this.embedding;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return Arrays.equals(this.getEmbedding(), other.getEmbedding());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + Arrays.hashCode(this.getEmbedding());
            return result;
        }

        public String toString() {
            return "Embeddings.Row(name=" + this.getName() + ", embedding=" + Arrays.toString(this.getEmbedding()) + ")";
        }
    }
}

