/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;

public class AgentRecommenderClient {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(3);
    private static final Path MODELS_DIR = Paths.get(System.getProperty("user.home") + "/.moderne/models", new String[0]);
    private ObjectMapper mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    @Nullable
    private static AgentRecommenderClient INSTANCE;
    private final Map<String, ArrayList<String>> recommendationsCache = Collections.synchronizedMap(new LinkedHashMap<String, ArrayList<String>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ArrayList<String>> eldest) {
            return this.size() > 1;
        }
    });

    public static synchronized AgentRecommenderClient getInstance() {
        if (INSTANCE == null && (INSTANCE = new AgentRecommenderClient()).checkForUpRequest() != 200) {
            String cmd = String.format("/usr/bin/python3 'import gradio\ngradio.'", MODELS_DIR);
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            INSTANCE.start();
        }
        return INSTANCE;
    }

    private void start() {
        Path pyLauncher = MODELS_DIR.resolve("get_recommendations.py");
        try {
            Files.copy(Objects.requireNonNull(AgentRecommenderClient.class.getResourceAsStream("/get_recommendations.py")), pyLauncher, StandardCopyOption.REPLACE_EXISTING);
            StringWriter sw = new StringWriter();
            PrintWriter procOut = new PrintWriter(sw);
            String cmd = String.format("/usr/bin/python3 %s/get_recommendations.py", MODELS_DIR);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            EXECUTOR_SERVICE.submit(() -> {
                new BufferedReader(new InputStreamReader(proc.getInputStream())).lines().forEach(procOut::println);
                new BufferedReader(new InputStreamReader(proc.getErrorStream())).lines().forEach(procOut::println);
            });
            if (!this.checkForUp(proc)) {
                throw new IllegalStateException("Unable to start model daemon. Output of process is:\n" + sw);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkForUp(Process proc) {
        for (int i = 0; i < 60; ++i) {
            try {
                if (!proc.isAlive() && proc.exitValue() != 0) {
                    return false;
                }
                if (this.checkForUpRequest() == 200) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private int checkForUpRequest() {
        try {
            HttpResponse response = Unirest.head((String)"http://127.0.0.1:7864").asString();
            return response.getStatus();
        }
        catch (UnirestException e) {
            return 523;
        }
    }

    public ArrayList<String> getRecommendations(String text, int n_batch) {
        HttpUrlConnectionSender http = new HttpUrlConnectionSender(Duration.ofSeconds(20L), Duration.ofSeconds(120L));
        HttpSender.Response raw = null;
        try {
            raw = http.post("http://127.0.0.1:7864/run/predict").withContent("application/json", this.mapper.writeValueAsBytes((Object)new GradioRequest(text, String.valueOf(n_batch)))).send();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (!raw.isSuccessful()) {
            throw new IllegalStateException("Unable to get embedding. HTTP " + raw.getCode() + " . " + raw.getBody());
        }
        ArrayList<String> recs = null;
        try {
            recs = ((GradioResponse)this.mapper.readValue(raw.getBodyAsBytes(), GradioResponse.class)).getRecommendations();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return recs;
    }

    static {
        if (!Files.exists(MODELS_DIR, new LinkOption[0]) && !MODELS_DIR.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to create models directory at " + MODELS_DIR);
        }
    }

    private static final class GradioRequest {
        private final String[] data;

        GradioRequest(String ... data) {
            this.data = data;
        }

        public String[] getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioRequest)) {
                return false;
            }
            GradioRequest other = (GradioRequest)o;
            return Arrays.deepEquals(this.getData(), other.getData());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            return result;
        }

        public String toString() {
            return "AgentRecommenderClient.GradioRequest(data=" + Arrays.deepToString(this.getData()) + ")";
        }
    }

    private static final class GradioResponse {
        private final List<String> data;

        public ArrayList<String> getRecommendations() {
            String d = this.data.get(0).replace("'", "\"");
            if (d.isEmpty()) {
                return new ArrayList<String>();
            }
            ObjectMapper mapper = new ObjectMapper();
            ArrayList recs = null;
            try {
                recs = (ArrayList)mapper.readValue(d, (TypeReference)new TypeReference<ArrayList<String>>(){});
            }
            catch (JsonProcessingException e) {
                return new ArrayList<String>();
            }
            return recs;
        }

        public GradioResponse(List<String> data) {
            this.data = data;
        }

        public List<String> getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradioResponse)) {
                return false;
            }
            GradioResponse other = (GradioResponse)o;
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "AgentRecommenderClient.GradioResponse(data=" + this.getData() + ")";
        }
    }
}

