/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.search;

import io.moderne.ai.AgentRecommenderClient;
import io.moderne.ai.table.Recommendations;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public final class GetRecommendations
extends Recipe {
    @Option(displayName="batch size", description="batch size for testing purposes", example="512")
    private final int n_batch;
    private final transient Recommendations recommendations_table = new Recommendations(this);
    private static final SecureRandom secureRandom = new SecureRandom();

    public String getDisplayName() {
        return "Get recommendations";
    }

    public String getDescription() {
        return "This recipe calls an AI model to get recommendations for modernizing the code base by looking at a sample of method declarations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                int randomNumber = secureRandom.nextInt(200);
                if (randomNumber == 0) {
                    long time = System.nanoTime();
                    ArrayList<String> recommendations = AgentRecommenderClient.getInstance().getRecommendations(md.printTrimmed(this.getCursor()), GetRecommendations.this.n_batch);
                    int tokenSize = (int)((double)md.printTrimmed(this.getCursor()).length() / 3.5 + (double)recommendations.toString().length() / 3.5);
                    double elapsedTime = (double)(System.nanoTime() - time) / 1.0E9;
                    GetRecommendations.this.recommendations_table.insertRow(ctx, new Recommendations.Row(md.getSimpleName(), GetRecommendations.this.n_batch, elapsedTime, tokenSize, recommendations));
                }
                return md;
            }
        };
    }

    public GetRecommendations(int n_batch) {
        this.n_batch = n_batch;
    }

    public int getN_batch() {
        return this.n_batch;
    }

    public Recommendations getRecommendations_table() {
        return this.recommendations_table;
    }

    public String toString() {
        return "GetRecommendations(n_batch=" + this.getN_batch() + ", recommendations_table=" + (Object)((Object)this.getRecommendations_table()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetRecommendations)) {
            return false;
        }
        GetRecommendations other = (GetRecommendations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.getN_batch() == other.getN_batch();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetRecommendations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getN_batch();
        return result;
    }
}

