/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.search;

import io.moderne.ai.SpellCheckerClient;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;

public final class SpellCheckCommentsInFrench
extends Recipe {
    public String getDisplayName() {
        return "Fix mis-coded comments in French";
    }

    public String getDescription() {
        return "Use spellchecker to fix mis-coded French comments. Mis-coded comments will contain either '?' or '\ufffd'.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                return space.withComments(ListUtils.map((List)space.getComments(), c -> {
                    TextComment tc;
                    String commentText;
                    if (!c.isMultiline() && !(commentText = (tc = (TextComment)c).getText()).isEmpty()) {
                        String fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText);
                        return tc.withText(fixedComment);
                    }
                    return c;
                }));
            }
        };
    }

    public String toString() {
        return "SpellCheckCommentsInFrench()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpellCheckCommentsInFrench)) {
            return false;
        }
        SpellCheckCommentsInFrench other = (SpellCheckCommentsInFrench)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpellCheckCommentsInFrench;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

