/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.table;

import java.util.ArrayList;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class Recommendations
extends DataTable<Row> {
    public Recommendations(Recipe recipe) {
        super(recipe, "Recommendations", "Collects the recommendations based on sampled methods.");
    }

    public static final class Row {
        @Column(displayName="Name", description="Name of the class or method")
        private final String name;
        @Column(displayName="Number of batches", description="n_batch value passed to llamacpp")
        private final int n_batch;
        @Column(displayName="Lantency", description="Latency in seconds to get recommendations")
        private final double latency;
        @Column(displayName="Token size", description="Estimated token size for input and output")
        private final int tokenSize;
        @Column(displayName="Recommendation", description="The recommendations based on the method")
        private final ArrayList<String> Recommendations;

        public Row(String name, int n_batch, double latency, int tokenSize, ArrayList<String> Recommendations2) {
            this.name = name;
            this.n_batch = n_batch;
            this.latency = latency;
            this.tokenSize = tokenSize;
            this.Recommendations = Recommendations2;
        }

        public String getName() {
            return this.name;
        }

        public int getN_batch() {
            return this.n_batch;
        }

        public double getLatency() {
            return this.latency;
        }

        public int getTokenSize() {
            return this.tokenSize;
        }

        public ArrayList<String> getRecommendations() {
            return this.Recommendations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getN_batch() != other.getN_batch()) {
                return false;
            }
            if (Double.compare(this.getLatency(), other.getLatency()) != 0) {
                return false;
            }
            if (this.getTokenSize() != other.getTokenSize()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ArrayList<String> this$Recommendations = this.getRecommendations();
            ArrayList<String> other$Recommendations = other.getRecommendations();
            return !(this$Recommendations == null ? other$Recommendations != null : !((Object)this$Recommendations).equals(other$Recommendations));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getN_batch();
            long $latency = Double.doubleToLongBits(this.getLatency());
            result = result * 59 + (int)($latency >>> 32 ^ $latency);
            result = result * 59 + this.getTokenSize();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ArrayList<String> $Recommendations = this.getRecommendations();
            result = result * 59 + ($Recommendations == null ? 43 : ((Object)$Recommendations).hashCode());
            return result;
        }

        public String toString() {
            return "Recommendations.Row(name=" + this.getName() + ", n_batch=" + this.getN_batch() + ", latency=" + this.getLatency() + ", tokenSize=" + this.getTokenSize() + ", Recommendations=" + this.getRecommendations() + ")";
        }
    }
}

