/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.internal.lang.Nullable;

public class AgentRecommenderClient {
    @Nullable
    private static AgentRecommenderClient INSTANCE;
    private static HashMap<String, String> methodsToSample;

    public static synchronized AgentRecommenderClient getInstance() {
        if (INSTANCE == null) {
            File f = new File("/app/llama.cpp/main");
            if (f.exists() && !f.isDirectory()) {
                INSTANCE = new AgentRecommenderClient();
                return INSTANCE;
            }
            StringWriter sw = new StringWriter();
            PrintWriter procOut = new PrintWriter(sw);
            try {
                Runtime runtime = Runtime.getRuntime();
                Process proc_make = runtime.exec(new String[]{"/bin/sh", "-c", "make -C /app/llama.cpp"});
                proc_make.waitFor();
                new BufferedReader(new InputStreamReader(proc_make.getInputStream())).lines().forEach(procOut::println);
                new BufferedReader(new InputStreamReader(proc_make.getErrorStream())).lines().forEach(procOut::println);
                if (proc_make.exitValue() != 0) {
                    throw new RuntimeException("Failed to make llama.cpp\n" + sw);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e + "\nOutput: " + sw);
            }
            INSTANCE = new AgentRecommenderClient();
            return INSTANCE;
        }
        return INSTANCE;
    }

    public static void populateMethodsToSample(String pathToCenters) {
        HashMap<String, String> tempMethodsToSample = new HashMap<String, String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pathToCenters));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String source = line.split(" ")[0];
                String methodCall = line.split(" ")[1];
                tempMethodsToSample.put(source, methodCall);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read which methods to sample. " + e);
        }
        methodsToSample = tempMethodsToSample;
    }

    public static HashMap<String, String> getMethodsToSample() {
        return methodsToSample;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrayList<String> getRecommendations(String code, int batch_size) {
        StringWriter sw = new StringWriter();
        PrintWriter procOut = new PrintWriter(sw);
        StringWriter errorSw = new StringWriter();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader("/app/prompt.txt"));){
            ArrayList<String> arrayList;
            try (FileWriter fileWriter = new FileWriter("/app/input.txt", false);){
                String line;
                StringBuilder promptContent = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    promptContent.append(line).append("\n");
                }
                fileWriter.write("[INST]" + promptContent + code + "```\n[/INST]1.");
                fileWriter.close();
                String contextLength = String.valueOf((int)((double)code.length() / 3.5) + 400);
                String cmd = "/app/llama.cpp/main -m /MODELS/codellama.gguf";
                String flags = " -f /app/input.txt --temp 0.50 -n 150 -c " + contextLength + " 2>/app/llama_log.txt --no-display-prompt -b " + batch_size;
                Runtime runtime = Runtime.getRuntime();
                Process proc_llama = runtime.exec(new String[]{"/bin/sh", "-c", cmd + flags});
                proc_llama.waitFor();
                new BufferedReader(new InputStreamReader(proc_llama.getInputStream())).lines().forEach(procOut::println);
                ArrayList<String> recommendations = this.parseRecommendations("1." + sw);
                if (recommendations.isEmpty()) {
                    String logLine;
                    BufferedReader bufferedReaderLog = new BufferedReader(new FileReader("/app/llama_log.txt"));
                    StringBuilder logContent = new StringBuilder();
                    while ((logLine = bufferedReaderLog.readLine()) != null) {
                        logContent.append(logLine).append("\n");
                    }
                    bufferedReaderLog.close();
                    throw new RuntimeException("Logs: " + logContent);
                }
                arrayList = recommendations;
            }
            return arrayList;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e + "\nOutput: " + errorSw);
        }
    }

    public ArrayList<String> parseRecommendations(String recommendations) {
        if (recommendations.equals("[]")) {
            return new ArrayList<String>();
        }
        String patternString = "\\b\\d+[.:\\-]\\s+(.*?)\\s*(?=\\b\\d+[.:\\-]|\\Z)";
        Pattern pattern = Pattern.compile(patternString, 32);
        Matcher matcher = pattern.matcher(recommendations);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        return matches;
    }

    public boolean isRelated(String query, String code) {
        boolean bl;
        StringWriter sw = new StringWriter();
        PrintWriter procOut = new PrintWriter(sw);
        StringWriter errorSw = new StringWriter();
        FileWriter fileWriter = new FileWriter("/app/inputRelated.txt", false);
        try {
            String promptContent = "Does this query match the code snippet?\n";
            promptContent = promptContent + "Query: " + query + "\n";
            promptContent = promptContent + "Code: " + code + "\n";
            promptContent = promptContent + "Answer as 'ANS: Yes' or 'ANS: No'.\n";
            fileWriter.write("[INST]" + promptContent + "[/INST]ANS:");
            fileWriter.close();
            String contextLength = String.valueOf((int)((double)(code.length() + query.length()) / 3.5) + 100);
            String cmd = "/app/llama.cpp/main -m /MODELS/codellama.gguf";
            String flags = " -f /app/inputRelated.txt --temp 0.01 -n 2 -c " + contextLength + " 2>/app/llama_log.txt --no-display-prompt";
            Runtime runtime = Runtime.getRuntime();
            Process proc_llama = runtime.exec(new String[]{"/bin/sh", "-c", cmd + flags});
            proc_llama.waitFor();
            new BufferedReader(new InputStreamReader(proc_llama.getInputStream())).lines().forEach(procOut::println);
            bl = this.parseRelated(sw);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e + "\nOutput: " + errorSw);
            }
        }
        fileWriter.close();
        return bl;
    }

    private boolean parseRelated(StringWriter sw) {
        return sw.toString().contains("Yes") || sw.toString().contains("yes");
    }
}

