/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import io.moderne.ai.table.MethodInUse;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class ListAllMethodsUsed
extends Recipe {
    private final transient MethodInUse methodInUse = new MethodInUse(this);

    public String getDisplayName() {
        return "List all methods used";
    }

    public String getDescription() {
        return "List all methods used in any Java source file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                cu.getTypesInUse().getUsedMethods().forEach(type -> ListAllMethodsUsed.this.methodInUse.insertRow(ctx, new MethodInUse.Row(Optional.ofNullable(type.getDeclaringType()).map(Object::toString).orElse(""), type.getName(), Optional.of(type.getReturnType()).map(Object::toString).orElse(""), type.getParameterNames().stream().collect(Collectors.joining(", ")), type.getParameterTypes().stream().map(Object::toString).collect(Collectors.joining(", ")))));
                return cu;
            }
        };
    }
}

