/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.research;

import io.moderne.ai.AgentRecommenderClient;
import io.moderne.ai.RelatedModelClient;
import io.moderne.ai.table.EmbeddingPerformance;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindCodeThatResembles
extends Recipe {
    @Option(displayName="Resembles", description="The text, either a natural language description or a code sample, that you are looking for.", example="HTTP request with Content-Type application/json")
    private final String resembles;
    @Option(displayName="Method filters", description="Since AI based matching has a higher latency than rules based matching, filter the methods that are searched for the `resembles` text. You must include at least one method pattern.", example="kong.unirest.* *(..)")
    private final List<String> methodFilters;
    @Option(displayName="Threshold", description="Tunes the sensitivity for matching. The lower the threshold, the stricter the matching is. The higher the threshold, the more matches. Must be between 0 and 1, but we recommend between 0.15-0.35.", example="0.25")
    private final String threshold;
    private final transient EmbeddingPerformance performance = new EmbeddingPerformance(this);

    public String getDisplayName() {
        return "Find method invocations that resemble a pattern";
    }

    public String getDescription() {
        return "This recipe uses a hybrid rules-based and AI approach to find a method invocation that resembles a search string.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final ArrayList<MethodMatcher> methodMatchers = new ArrayList<MethodMatcher>(this.methodFilters.size());
        for (String m : this.methodFilters) {
            methodMatchers.add(new MethodMatcher(m, true));
        }
        ArrayList<UsesMethod> preconditions = new ArrayList<UsesMethod>(methodMatchers.size());
        for (MethodMatcher m : methodMatchers) {
            preconditions.add(new UsesMethod(m));
        }
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])preconditions.toArray(new TreeVisitor[0])), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Nullable
            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    this.getCursor().putMessage("count", (Object)new AtomicInteger());
                    this.getCursor().putMessage("max", (Object)new AtomicLong());
                    this.getCursor().putMessage("histogram", (Object)new EmbeddingPerformance.Histogram());
                    J visit = (J)super.visit(tree, (Object)ctx);
                    if (((AtomicInteger)this.getCursor().getMessage("count", (Object)new AtomicInteger())).get() > 0) {
                        Duration max = Duration.ofNanos(Objects.requireNonNull((AtomicLong)this.getCursor().getMessage("max")).get());
                        FindCodeThatResembles.this.performance.insertRow(ctx, new EmbeddingPerformance.Row(((SourceFile)tree).getSourcePath().toString(), Objects.requireNonNull((AtomicInteger)this.getCursor().getMessage("count")).get(), Objects.requireNonNull((EmbeddingPerformance.Histogram)this.getCursor().getMessage("histogram")).getBuckets(), max));
                    }
                    return visit;
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                boolean matches = false;
                for (MethodMatcher methodMatcher : methodMatchers) {
                    if (!methodMatcher.matches((MethodCall)method)) continue;
                    matches = true;
                }
                if (!matches) {
                    return super.visitMethodInvocation(method, (Object)ctx);
                }
                double thresholdParsed = FindCodeThatResembles.this.threshold != null ? Double.parseDouble(FindCodeThatResembles.this.threshold) : 0.5;
                RelatedModelClient.Relatedness related = RelatedModelClient.getInstance().getRelatedness(FindCodeThatResembles.this.resembles, method.printTrimmed(this.getCursor()), thresholdParsed);
                for (Duration timing : related.getEmbeddingTimings()) {
                    Objects.requireNonNull((AtomicInteger)this.getCursor().getNearestMessage("count")).incrementAndGet();
                    Objects.requireNonNull((EmbeddingPerformance.Histogram)this.getCursor().getNearestMessage("histogram")).add(timing);
                    AtomicLong max = (AtomicLong)this.getCursor().getNearestMessage("max");
                    if (Objects.requireNonNull(max).get() >= timing.toNanos()) continue;
                    max.set(timing.toNanos());
                }
                return related.isRelated() && AgentRecommenderClient.getInstance().isRelated(FindCodeThatResembles.this.resembles, method.printTrimmed(this.getCursor())) ? (J.MethodInvocation)SearchResult.found((Tree)method) : super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    public FindCodeThatResembles(String resembles, List<String> methodFilters, String threshold) {
        this.resembles = resembles;
        this.methodFilters = methodFilters;
        this.threshold = threshold;
    }

    public String getResembles() {
        return this.resembles;
    }

    public List<String> getMethodFilters() {
        return this.methodFilters;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public EmbeddingPerformance getPerformance() {
        return this.performance;
    }

    public String toString() {
        return "FindCodeThatResembles(resembles=" + this.getResembles() + ", methodFilters=" + this.getMethodFilters() + ", threshold=" + this.getThreshold() + ", performance=" + (Object)((Object)this.getPerformance()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCodeThatResembles)) {
            return false;
        }
        FindCodeThatResembles other = (FindCodeThatResembles)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$resembles = this.getResembles();
        String other$resembles = other.getResembles();
        if (this$resembles == null ? other$resembles != null : !this$resembles.equals(other$resembles)) {
            return false;
        }
        List<String> this$methodFilters = this.getMethodFilters();
        List<String> other$methodFilters = other.getMethodFilters();
        if (this$methodFilters == null ? other$methodFilters != null : !((Object)this$methodFilters).equals(other$methodFilters)) {
            return false;
        }
        String this$threshold = this.getThreshold();
        String other$threshold = other.getThreshold();
        return !(this$threshold == null ? other$threshold != null : !this$threshold.equals(other$threshold));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindCodeThatResembles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resembles = this.getResembles();
        result = result * 59 + ($resembles == null ? 43 : $resembles.hashCode());
        List<String> $methodFilters = this.getMethodFilters();
        result = result * 59 + ($methodFilters == null ? 43 : ((Object)$methodFilters).hashCode());
        String $threshold = this.getThreshold();
        result = result * 59 + ($threshold == null ? 43 : $threshold.hashCode());
        return result;
    }
}

