/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.research;

import io.moderne.ai.AgentRecommenderClient;
import io.moderne.ai.table.Recommendations;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public final class GetRecommendations
extends Recipe {
    @Option(displayName="batch size", description="batch size for testing purposes", example="512")
    private final int n_batch;
    @Option(displayName="random sampling", description="Do random sampling or use clusters based on embeddings to sample.")
    private final Boolean random_sampling;
    private final String path = "/app/methodsToSample.txt";
    private final transient Recommendations recommendations_table = new Recommendations(this);
    private static final SecureRandom secureRandom = new SecureRandom();

    public String getDisplayName() {
        return "Get recommendations";
    }

    public String getDescription() {
        return "This recipe calls an AI model to get recommendations for modernizing the code base by looking at a sample of method declarations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        if (!this.random_sampling.booleanValue()) {
            AgentRecommenderClient.populateMethodsToSample("/app/methodsToSample.txt");
        }
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                HashMap<String, String> methodsToSample;
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                Boolean isMethodToSample = false;
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                String source = javaSourceFile.getSourcePath().toString();
                isMethodToSample = GetRecommendations.this.random_sampling != false ? Boolean.valueOf(secureRandom.nextInt(200) == 0) : Boolean.valueOf((methodsToSample = AgentRecommenderClient.getMethodsToSample()).get(source) != null && methodsToSample.get(source).equals(md.getSimpleName()));
                if (isMethodToSample.booleanValue()) {
                    long time = System.nanoTime();
                    ArrayList<String> recommendations = AgentRecommenderClient.getInstance().getRecommendations(md.printTrimmed(this.getCursor()), GetRecommendations.this.n_batch);
                    List recommendationsQuoted = recommendations.stream().map(element -> "\"" + element + "\"").collect(Collectors.toList());
                    String recommendationsAsString = "[" + String.join((CharSequence)", ", recommendationsQuoted) + "]";
                    int tokenSize = (int)((double)md.printTrimmed(this.getCursor()).length() / 3.5 + (double)recommendations.toString().length() / 3.5);
                    double elapsedTime = (double)(System.nanoTime() - time) / 1.0E9;
                    GetRecommendations.this.recommendations_table.insertRow(ctx, new Recommendations.Row(md.getSimpleName(), GetRecommendations.this.n_batch, elapsedTime, tokenSize, recommendationsAsString));
                }
                return md;
            }
        };
    }

    public GetRecommendations(int n_batch, Boolean random_sampling) {
        this.n_batch = n_batch;
        this.random_sampling = random_sampling;
    }

    public int getN_batch() {
        return this.n_batch;
    }

    public Boolean getRandom_sampling() {
        return this.random_sampling;
    }

    public String getPath() {
        return this.path;
    }

    public Recommendations getRecommendations_table() {
        return this.recommendations_table;
    }

    public String toString() {
        return "GetRecommendations(n_batch=" + this.getN_batch() + ", random_sampling=" + this.getRandom_sampling() + ", path=" + this.getPath() + ", recommendations_table=" + (Object)((Object)this.getRecommendations_table()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetRecommendations)) {
            return false;
        }
        GetRecommendations other = (GetRecommendations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getN_batch() != other.getN_batch()) {
            return false;
        }
        Boolean this$random_sampling = this.getRandom_sampling();
        Boolean other$random_sampling = other.getRandom_sampling();
        if (this$random_sampling == null ? other$random_sampling != null : !((Object)this$random_sampling).equals(other$random_sampling)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetRecommendations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getN_batch();
        Boolean $random_sampling = this.getRandom_sampling();
        result = result * 59 + ($random_sampling == null ? 43 : ((Object)$random_sampling).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

