/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LanguageCompositionReport;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.binary.Binary;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.CountLinesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.json.tree.Json;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.python.tree.Py;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.xml.tree.Xml;
import org.openrewrite.yaml.tree.Yaml;

public final class LanguageComposition
extends Recipe {
    private final transient LanguageCompositionReport report = new LanguageCompositionReport(this);

    public String getDisplayName() {
        return "Language composition report";
    }

    public String getDescription() {
        return "Counts the number of lines of the various kinds of source code and data formats parsed by OpenRewrite. Comments are not included in line counts. This recipe emits its results as a data table, making no changes to any source file.";
    }

    public List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        int cobolFileCount = 0;
        int cobolLineCount = 0;
        int groovyFileCount = 0;
        int groovyLineCount = 0;
        int hclFileCount = 0;
        int hclLineCount = 0;
        int javaFileCount = 0;
        int javaLineCount = 0;
        int jsonFileCount = 0;
        int jsonLineCount = 0;
        int kotlinFileCount = 0;
        int kotlinLineCount = 0;
        int plainTextFileCount = 0;
        int plainTextLineCount = 0;
        int propertiesFileCount = 0;
        int propertiesLineCount = 0;
        int protobufFileCount = 0;
        int protobufLineCount = 0;
        int pythonFileCount = 0;
        int pythonLineCount = 0;
        int xmlFileCount = 0;
        int xmlLineCount = 0;
        int yamlFileCount = 0;
        int yamlLineCount = 0;
        int otherFileCount = 0;
        for (SourceFile s : before) {
            if (s instanceof Quark || s instanceof Binary || s instanceof Remote) {
                ++otherFileCount;
                continue;
            }
            if ("org.openrewrite.cobol.tree.Cobol".equals(s.getClass().getName())) {
                ++cobolFileCount;
                cobolLineCount += LanguageComposition.genericLineCount(s);
                continue;
            }
            if (s instanceof K) {
                ++kotlinFileCount;
                kotlinLineCount += CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof G) {
                ++groovyFileCount;
                groovyLineCount += org.openrewrite.groovy.CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof Py) {
                ++pythonFileCount;
                pythonLineCount += LanguageComposition.genericLineCount(s);
                continue;
            }
            if (s instanceof J) {
                ++javaFileCount;
                javaLineCount += CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof Json) {
                ++jsonFileCount;
                jsonLineCount += org.openrewrite.json.CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof Hcl) {
                ++hclFileCount;
                hclLineCount += org.openrewrite.hcl.CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof Properties) {
                ++propertiesFileCount;
                propertiesLineCount += org.openrewrite.properties.CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof Proto) {
                ++protobufFileCount;
                protobufLineCount += org.openrewrite.protobuf.CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof Xml) {
                ++xmlFileCount;
                xmlLineCount += org.openrewrite.xml.CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (s instanceof Yaml) {
                ++yamlFileCount;
                yamlLineCount += org.openrewrite.yaml.CountLinesVisitor.countLines((Tree)s);
                continue;
            }
            if (!(s instanceof PlainText)) continue;
            ++plainTextFileCount;
            plainTextLineCount += LanguageComposition.genericLineCount(s);
        }
        this.report.insertRow(ctx, new LanguageCompositionReport.Row(cobolFileCount, cobolLineCount, groovyFileCount, groovyLineCount, hclFileCount, hclLineCount, javaFileCount, javaLineCount, jsonFileCount, jsonLineCount, kotlinFileCount, kotlinLineCount, plainTextFileCount, plainTextLineCount, propertiesFileCount, propertiesLineCount, protobufFileCount, protobufLineCount, pythonFileCount, pythonLineCount, xmlFileCount, xmlLineCount, yamlFileCount, yamlLineCount, otherFileCount));
        return before;
    }

    private static int genericLineCount(SourceFile s) {
        LineCounter counter = new LineCounter();
        s.printAll((PrintOutputCapture)counter);
        return counter.getLineCount();
    }

    public LanguageCompositionReport getReport() {
        return this.report;
    }

    public String toString() {
        return "LanguageComposition(report=" + (Object)((Object)this.getReport()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LanguageComposition)) {
            return false;
        }
        LanguageComposition other = (LanguageComposition)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof LanguageComposition;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static class LineCounter
    extends PrintOutputCapture<Integer> {
        private int count;

        public LineCounter() {
            super((Object)0);
        }

        public PrintOutputCapture<Integer> append(char c) {
            if (c == '\n') {
                ++this.count;
            }
            return this;
        }

        public PrintOutputCapture<Integer> append(@Nullable String text) {
            if (text == null) {
                return this;
            }
            if (text.contains("\n")) {
                ++this.count;
            }
            return this;
        }

        int getLineCount() {
            return this.count;
        }
    }
}

