/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

@JsonIgnoreType
public class LanguageCompositionReport
extends DataTable<Row> {
    public LanguageCompositionReport(Recipe recipe) {
        super(recipe, "Language composition report", "Counts the number of files and lines of source code in the various formats OpenRewrite knows how to parse.");
    }

    public static final class Row {
        @Column(displayName="Cobol file count", description="Count of files containing code, including copybooks.")
        private final int cobolFileCount;
        @Column(displayName="Cobol line count", description="Count of lines of cobol code, including copybooks.")
        private final int cobolLineCount;
        @Column(displayName="Groovy file count", description="Count of files containing groovy code, including build.gradle files.")
        private final int groovyFileCount;
        @Column(displayName="Groovy line count", description="Count of lines of groovy code, including build.gradle files.")
        private final int groovyLineCount;
        @Column(displayName="HCL file count", description="Count of files containing Hashicorp Configuration Language (HCL) code, including Terraform files.")
        private final int hclFileCount;
        @Column(displayName="HCL line count", description="Count of lines of Hashicorp Configuration Language (HCL) code, including Terraform files.")
        private final int hclLineCount;
        @Column(displayName="Java file count", description="Count of files containing Java code.")
        private final int javaFileCount;
        @Column(displayName="Java line count", description="Count of lines of Java code.")
        private final int javaLineCount;
        @Column(displayName="Javascript file count", description="Count of files containing JSON data.")
        private final int jsonFileCount;
        @Column(displayName="Javascript line count", description="Count of lines of JSON data.")
        private final int jsonLineCount;
        @Column(displayName="Kotlin file count", description="Count of files containing Kotlin code.")
        private final int kotlinFileCount;
        @Column(displayName="Kotlin line count", description="Count of lines of Kotlin code.")
        private final int kotlinLineCount;
        @Column(displayName="Plain text file count", description="Count of files containing plain text.")
        private final int plainTextFileCount;
        @Column(displayName="Plain text line count", description="Count of lines of plain text.")
        private final int plainTextLineCount;
        @Column(displayName="Properties file count", description="Count of files containing Java properties.")
        private final int propertiesFileCount;
        @Column(displayName="Properties line count", description="Count of lines of Java properties files.")
        private final int propertiesLineCount;
        @Column(displayName="Protobuf file count", description="Count of files containing Google Protocol Buffers (protobuf) code.")
        private final int protobufFileCount;
        @Column(displayName="Protobuf line count", description="Count of lines of Google Protocol Buffers (protobuf) code.")
        private final int protobufLineCount;
        @Column(displayName="Python file count", description="Count of files containing Python code.")
        private final int pythonFileCount;
        @Column(displayName="Python line count", description="Count of lines of Python code.")
        private final int pythonLineCount;
        @Column(displayName="XML file count", description="Count of files containing XML data, including Maven poms.")
        private final int xmlFileCount;
        @Column(displayName="XML line count", description="Count of lines of XML data, including Maven poms.")
        private final int xmlLineCount;
        @Column(displayName="YAML file count", description="Count of files containing YAML data.")
        private final int yamlFileCount;
        @Column(displayName="YAML line count", description="Count of lines of YAML data.")
        private final int yamlLineCount;
        @Column(displayName="Other file count", description="Count of files that are not otherwise parsed.")
        private final int otherFileCount;

        public Row(int cobolFileCount, int cobolLineCount, int groovyFileCount, int groovyLineCount, int hclFileCount, int hclLineCount, int javaFileCount, int javaLineCount, int jsonFileCount, int jsonLineCount, int kotlinFileCount, int kotlinLineCount, int plainTextFileCount, int plainTextLineCount, int propertiesFileCount, int propertiesLineCount, int protobufFileCount, int protobufLineCount, int pythonFileCount, int pythonLineCount, int xmlFileCount, int xmlLineCount, int yamlFileCount, int yamlLineCount, int otherFileCount) {
            this.cobolFileCount = cobolFileCount;
            this.cobolLineCount = cobolLineCount;
            this.groovyFileCount = groovyFileCount;
            this.groovyLineCount = groovyLineCount;
            this.hclFileCount = hclFileCount;
            this.hclLineCount = hclLineCount;
            this.javaFileCount = javaFileCount;
            this.javaLineCount = javaLineCount;
            this.jsonFileCount = jsonFileCount;
            this.jsonLineCount = jsonLineCount;
            this.kotlinFileCount = kotlinFileCount;
            this.kotlinLineCount = kotlinLineCount;
            this.plainTextFileCount = plainTextFileCount;
            this.plainTextLineCount = plainTextLineCount;
            this.propertiesFileCount = propertiesFileCount;
            this.propertiesLineCount = propertiesLineCount;
            this.protobufFileCount = protobufFileCount;
            this.protobufLineCount = protobufLineCount;
            this.pythonFileCount = pythonFileCount;
            this.pythonLineCount = pythonLineCount;
            this.xmlFileCount = xmlFileCount;
            this.xmlLineCount = xmlLineCount;
            this.yamlFileCount = yamlFileCount;
            this.yamlLineCount = yamlLineCount;
            this.otherFileCount = otherFileCount;
        }

        public int getCobolFileCount() {
            return this.cobolFileCount;
        }

        public int getCobolLineCount() {
            return this.cobolLineCount;
        }

        public int getGroovyFileCount() {
            return this.groovyFileCount;
        }

        public int getGroovyLineCount() {
            return this.groovyLineCount;
        }

        public int getHclFileCount() {
            return this.hclFileCount;
        }

        public int getHclLineCount() {
            return this.hclLineCount;
        }

        public int getJavaFileCount() {
            return this.javaFileCount;
        }

        public int getJavaLineCount() {
            return this.javaLineCount;
        }

        public int getJsonFileCount() {
            return this.jsonFileCount;
        }

        public int getJsonLineCount() {
            return this.jsonLineCount;
        }

        public int getKotlinFileCount() {
            return this.kotlinFileCount;
        }

        public int getKotlinLineCount() {
            return this.kotlinLineCount;
        }

        public int getPlainTextFileCount() {
            return this.plainTextFileCount;
        }

        public int getPlainTextLineCount() {
            return this.plainTextLineCount;
        }

        public int getPropertiesFileCount() {
            return this.propertiesFileCount;
        }

        public int getPropertiesLineCount() {
            return this.propertiesLineCount;
        }

        public int getProtobufFileCount() {
            return this.protobufFileCount;
        }

        public int getProtobufLineCount() {
            return this.protobufLineCount;
        }

        public int getPythonFileCount() {
            return this.pythonFileCount;
        }

        public int getPythonLineCount() {
            return this.pythonLineCount;
        }

        public int getXmlFileCount() {
            return this.xmlFileCount;
        }

        public int getXmlLineCount() {
            return this.xmlLineCount;
        }

        public int getYamlFileCount() {
            return this.yamlFileCount;
        }

        public int getYamlLineCount() {
            return this.yamlLineCount;
        }

        public int getOtherFileCount() {
            return this.otherFileCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getCobolFileCount() != other.getCobolFileCount()) {
                return false;
            }
            if (this.getCobolLineCount() != other.getCobolLineCount()) {
                return false;
            }
            if (this.getGroovyFileCount() != other.getGroovyFileCount()) {
                return false;
            }
            if (this.getGroovyLineCount() != other.getGroovyLineCount()) {
                return false;
            }
            if (this.getHclFileCount() != other.getHclFileCount()) {
                return false;
            }
            if (this.getHclLineCount() != other.getHclLineCount()) {
                return false;
            }
            if (this.getJavaFileCount() != other.getJavaFileCount()) {
                return false;
            }
            if (this.getJavaLineCount() != other.getJavaLineCount()) {
                return false;
            }
            if (this.getJsonFileCount() != other.getJsonFileCount()) {
                return false;
            }
            if (this.getJsonLineCount() != other.getJsonLineCount()) {
                return false;
            }
            if (this.getKotlinFileCount() != other.getKotlinFileCount()) {
                return false;
            }
            if (this.getKotlinLineCount() != other.getKotlinLineCount()) {
                return false;
            }
            if (this.getPlainTextFileCount() != other.getPlainTextFileCount()) {
                return false;
            }
            if (this.getPlainTextLineCount() != other.getPlainTextLineCount()) {
                return false;
            }
            if (this.getPropertiesFileCount() != other.getPropertiesFileCount()) {
                return false;
            }
            if (this.getPropertiesLineCount() != other.getPropertiesLineCount()) {
                return false;
            }
            if (this.getProtobufFileCount() != other.getProtobufFileCount()) {
                return false;
            }
            if (this.getProtobufLineCount() != other.getProtobufLineCount()) {
                return false;
            }
            if (this.getPythonFileCount() != other.getPythonFileCount()) {
                return false;
            }
            if (this.getPythonLineCount() != other.getPythonLineCount()) {
                return false;
            }
            if (this.getXmlFileCount() != other.getXmlFileCount()) {
                return false;
            }
            if (this.getXmlLineCount() != other.getXmlLineCount()) {
                return false;
            }
            if (this.getYamlFileCount() != other.getYamlFileCount()) {
                return false;
            }
            if (this.getYamlLineCount() != other.getYamlLineCount()) {
                return false;
            }
            return this.getOtherFileCount() == other.getOtherFileCount();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCobolFileCount();
            result = result * 59 + this.getCobolLineCount();
            result = result * 59 + this.getGroovyFileCount();
            result = result * 59 + this.getGroovyLineCount();
            result = result * 59 + this.getHclFileCount();
            result = result * 59 + this.getHclLineCount();
            result = result * 59 + this.getJavaFileCount();
            result = result * 59 + this.getJavaLineCount();
            result = result * 59 + this.getJsonFileCount();
            result = result * 59 + this.getJsonLineCount();
            result = result * 59 + this.getKotlinFileCount();
            result = result * 59 + this.getKotlinLineCount();
            result = result * 59 + this.getPlainTextFileCount();
            result = result * 59 + this.getPlainTextLineCount();
            result = result * 59 + this.getPropertiesFileCount();
            result = result * 59 + this.getPropertiesLineCount();
            result = result * 59 + this.getProtobufFileCount();
            result = result * 59 + this.getProtobufLineCount();
            result = result * 59 + this.getPythonFileCount();
            result = result * 59 + this.getPythonLineCount();
            result = result * 59 + this.getXmlFileCount();
            result = result * 59 + this.getXmlLineCount();
            result = result * 59 + this.getYamlFileCount();
            result = result * 59 + this.getYamlLineCount();
            result = result * 59 + this.getOtherFileCount();
            return result;
        }

        public String toString() {
            return "LanguageCompositionReport.Row(cobolFileCount=" + this.getCobolFileCount() + ", cobolLineCount=" + this.getCobolLineCount() + ", groovyFileCount=" + this.getGroovyFileCount() + ", groovyLineCount=" + this.getGroovyLineCount() + ", hclFileCount=" + this.getHclFileCount() + ", hclLineCount=" + this.getHclLineCount() + ", javaFileCount=" + this.getJavaFileCount() + ", javaLineCount=" + this.getJavaLineCount() + ", jsonFileCount=" + this.getJsonFileCount() + ", jsonLineCount=" + this.getJsonLineCount() + ", kotlinFileCount=" + this.getKotlinFileCount() + ", kotlinLineCount=" + this.getKotlinLineCount() + ", plainTextFileCount=" + this.getPlainTextFileCount() + ", plainTextLineCount=" + this.getPlainTextLineCount() + ", propertiesFileCount=" + this.getPropertiesFileCount() + ", propertiesLineCount=" + this.getPropertiesLineCount() + ", protobufFileCount=" + this.getProtobufFileCount() + ", protobufLineCount=" + this.getProtobufLineCount() + ", pythonFileCount=" + this.getPythonFileCount() + ", pythonLineCount=" + this.getPythonLineCount() + ", xmlFileCount=" + this.getXmlFileCount() + ", xmlLineCount=" + this.getXmlLineCount() + ", yamlFileCount=" + this.getYamlFileCount() + ", yamlLineCount=" + this.getYamlLineCount() + ", otherFileCount=" + this.getOtherFileCount() + ")";
        }
    }
}

