/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.CountLinesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.json.tree.Json;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.python.tree.Py;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.table.LanguageCompositionPerFile;
import org.openrewrite.table.LanguageCompositionPerRepository;
import org.openrewrite.text.PlainText;
import org.openrewrite.xml.tree.Xml;
import org.openrewrite.yaml.tree.Yaml;

public final class LanguageComposition
extends ScanningRecipe<Accumulator> {
    private final transient LanguageCompositionPerRepository report = new LanguageCompositionPerRepository((Recipe)this);
    private final transient LanguageCompositionPerFile perFileReport = new LanguageCompositionPerFile((Recipe)this);

    public String getDisplayName() {
        return "Language composition report";
    }

    public String getDescription() {
        return "Counts the number of lines of the various kinds of source code and data formats parsed by OpenRewrite. Comments are not included in line counts. This recipe emits its results as two data tables, making no changes to any source file. One data table is per-file, the other is per-repository.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                boolean hasParseFailure = s.getMarkers().findFirst(ParseExceptionResult.class).isPresent();
                if (s instanceof Quark || s instanceof Binary || s instanceof Remote) {
                    Counts quarkCounts = acc.getMap().computeIfAbsent("Other/unknown/unparseable", k -> new Counts());
                    ++quarkCounts.fileCount;
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Other/unknown/unparseable", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), 0, hasParseFailure));
                } else if (s.getClass().getName().startsWith("org.openrewrite.cobol.tree.Cobol")) {
                    Counts cobolCounts = acc.getMap().computeIfAbsent("Cobol", k -> new Counts());
                    ++cobolCounts.fileCount;
                    cobolCounts.lineCount += LanguageComposition.genericLineCount(s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Cobol", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), cobolCounts.lineCount, hasParseFailure));
                } else if (s instanceof K) {
                    Counts kotlinCounts = acc.getMap().computeIfAbsent("Kotlin", k -> new Counts());
                    ++kotlinCounts.fileCount;
                    kotlinCounts.lineCount += CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Kotlin", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), kotlinCounts.lineCount, hasParseFailure));
                } else if (s instanceof G) {
                    Counts groovyCounts = acc.getMap().computeIfAbsent("Groovy", k -> new Counts());
                    ++groovyCounts.fileCount;
                    groovyCounts.lineCount += org.openrewrite.groovy.CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Groovy", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), groovyCounts.lineCount, hasParseFailure));
                } else if (s instanceof Py) {
                    Counts pythonCounts = acc.getMap().computeIfAbsent("Python", k -> new Counts());
                    ++pythonCounts.fileCount;
                    pythonCounts.lineCount += LanguageComposition.genericLineCount(s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Python", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), pythonCounts.lineCount, hasParseFailure));
                } else if (s instanceof J) {
                    Counts javaCounts = acc.getMap().computeIfAbsent("Java", k -> new Counts());
                    ++javaCounts.fileCount;
                    javaCounts.lineCount += CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Java", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), javaCounts.lineCount, hasParseFailure));
                } else if (s instanceof Json) {
                    Counts jsonCounts = acc.getMap().computeIfAbsent("Json", k -> new Counts());
                    ++jsonCounts.fileCount;
                    jsonCounts.lineCount += org.openrewrite.json.CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Json", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), jsonCounts.lineCount, hasParseFailure));
                } else if (s instanceof Hcl) {
                    Counts hclCounts = acc.getMap().computeIfAbsent("Hcl", k -> new Counts());
                    ++hclCounts.fileCount;
                    hclCounts.lineCount += org.openrewrite.hcl.CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Hcl", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), hclCounts.lineCount, hasParseFailure));
                } else if (s instanceof Properties) {
                    Counts propertiesCounts = acc.getMap().computeIfAbsent("Properties", k -> new Counts());
                    ++propertiesCounts.fileCount;
                    propertiesCounts.lineCount += org.openrewrite.properties.CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Properties", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), propertiesCounts.lineCount, hasParseFailure));
                } else if (s instanceof Proto) {
                    Counts protobufCounts = acc.getMap().computeIfAbsent("Protobuf", k -> new Counts());
                    ++protobufCounts.fileCount;
                    protobufCounts.lineCount += org.openrewrite.protobuf.CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Protobuf", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), protobufCounts.lineCount, hasParseFailure));
                } else if (s instanceof Xml) {
                    Counts xmlCounts = acc.getMap().computeIfAbsent("Xml", k -> new Counts());
                    ++xmlCounts.fileCount;
                    xmlCounts.lineCount += org.openrewrite.xml.CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Xml", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), xmlCounts.lineCount, hasParseFailure));
                } else if (s instanceof Yaml) {
                    Counts yamlCounts = acc.getMap().computeIfAbsent("Yaml", k -> new Counts());
                    ++yamlCounts.fileCount;
                    yamlCounts.lineCount += org.openrewrite.yaml.CountLinesVisitor.countLines((Tree)s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Yaml", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), yamlCounts.lineCount, hasParseFailure));
                } else if (s instanceof PlainText) {
                    Counts plainTextCounts = acc.getMap().computeIfAbsent("Plain text", k -> new Counts());
                    ++plainTextCounts.fileCount;
                    plainTextCounts.lineCount += LanguageComposition.genericLineCount(s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Plain text", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), plainTextCounts.lineCount, hasParseFailure));
                } else {
                    Counts unknownCounts = acc.getMap().computeIfAbsent("Unknown", k -> new Counts());
                    ++unknownCounts.fileCount;
                    unknownCounts.lineCount += LanguageComposition.genericLineCount(s);
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Unknown", s.getClass().getName(), s.getWeight(id -> acc.getIds().add(System.identityHashCode(id))), unknownCounts.lineCount, hasParseFailure));
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        for (Map.Entry<String, Counts> entry : acc.getMap().entrySet()) {
            this.report.insertRow(ctx, new LanguageCompositionPerRepository.Row(entry.getKey(), entry.getValue().fileCount, entry.getValue().lineCount));
        }
        return Collections.emptyList();
    }

    private static int genericLineCount(SourceFile s) {
        LineCounter counter = new LineCounter();
        s.printAll((PrintOutputCapture)counter);
        return counter.getLineCount();
    }

    public LanguageCompositionPerRepository getReport() {
        return this.report;
    }

    public LanguageCompositionPerFile getPerFileReport() {
        return this.perFileReport;
    }

    public String toString() {
        return "LanguageComposition(report=" + (Object)((Object)this.getReport()) + ", perFileReport=" + (Object)((Object)this.getPerFileReport()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LanguageComposition)) {
            return false;
        }
        LanguageComposition other = (LanguageComposition)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof LanguageComposition;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static class Accumulator {
        Map<String, Counts> map = new HashMap<String, Counts>();
        Set<Integer> ids = new LinkedHashSet<Integer>();

        public Map<String, Counts> getMap() {
            return this.map;
        }

        public Set<Integer> getIds() {
            return this.ids;
        }

        public void setMap(Map<String, Counts> map) {
            this.map = map;
        }

        public void setIds(Set<Integer> ids) {
            this.ids = ids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Counts> this$map = this.getMap();
            Map<String, Counts> other$map = other.getMap();
            if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
                return false;
            }
            Set<Integer> this$ids = this.getIds();
            Set<Integer> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Accumulator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Counts> $map = this.getMap();
            result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
            Set<Integer> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result;
        }

        public String toString() {
            return "LanguageComposition.Accumulator(map=" + this.getMap() + ", ids=" + this.getIds() + ")";
        }
    }

    private static class Counts {
        int lineCount;
        int fileCount;

        private Counts() {
        }
    }

    private static class LineCounter
    extends PrintOutputCapture<Integer> {
        private int count;

        public LineCounter() {
            super((Object)0);
        }

        public PrintOutputCapture<Integer> append(char c) {
            if (c == '\n') {
                ++this.count;
            }
            return this;
        }

        public PrintOutputCapture<Integer> append(@Nullable String text) {
            if (text == null) {
                return this;
            }
            if (text.contains("\n")) {
                this.count += text.split("([\r\n]+)").length;
            }
            return this;
        }

        int getLineCount() {
            return this.count;
        }
    }
}

