/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.table.DuplicateSourceFiles;

public class FindDuplicateSourceFiles
extends ScanningRecipe<Map<Path, List<String>>> {
    transient DuplicateSourceFiles duplicateSourceFiles = new DuplicateSourceFiles((Recipe)this);

    public String getDisplayName() {
        return "Find duplicate source files";
    }

    public String getDescription() {
        return "Record the presence of source files that occur more than once in an LST.";
    }

    public Map<Path, List<String>> getInitialValue(ExecutionContext ctx) {
        return new HashMap<Path, List<String>>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<Path, List<String>> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    acc.computeIfAbsent(((SourceFile)tree).getSourcePath(), k -> new ArrayList()).add(tree.getClass().getSimpleName());
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Map<Path, List<String>> acc, ExecutionContext ctx) {
        for (Map.Entry<Path, List<String>> path : acc.entrySet()) {
            if (path.getValue().size() <= 1) continue;
            this.duplicateSourceFiles.insertRow(ctx, new DuplicateSourceFiles.Row(path.getKey().toString(), path.getValue().size(), new HashSet<String>((Collection)path.getValue())));
        }
        return Collections.emptyList();
    }
}

