/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.PathUtils;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.CountLinesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.json.tree.Json;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.python.tree.Py;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.table.LanguageCompositionPerFile;
import org.openrewrite.table.LanguageCompositionPerFolder;
import org.openrewrite.table.LanguageCompositionPerRepository;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;
import org.openrewrite.xml.tree.Xml;
import org.openrewrite.yaml.tree.Yaml;

public final class LanguageComposition
extends ScanningRecipe<Accumulator> {
    private final transient LanguageCompositionPerRepository perRepositoryReport = new LanguageCompositionPerRepository((Recipe)this);
    private final transient LanguageCompositionPerFolder perFolderReport = new LanguageCompositionPerFolder((Recipe)this);
    private final transient LanguageCompositionPerFile perFileReport = new LanguageCompositionPerFile((Recipe)this);

    public String getDisplayName() {
        return "Language composition report";
    }

    public String getDescription() {
        return "Counts the number of lines of the various kinds of source code and data formats parsed by OpenRewrite. Comments are not included in line counts. This recipe emits its results as two data tables, making no changes to any source file. One data table is per-file, the other is per-repository.";
    }

    private static String containingFolderPath(SourceFile s) {
        String sourcePath = PathUtils.separatorsToUnix((String)s.getSourcePath().toString());
        int lastSlash = sourcePath.lastIndexOf(47);
        if (lastSlash == -1) {
            return "";
        }
        return sourcePath.substring(0, lastSlash);
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                String folderPath = LanguageComposition.containingFolderPath(s);
                boolean hasParseFailure = s.getMarkers().findFirst(ParseExceptionResult.class).isPresent();
                if (s instanceof Quark || s instanceof Binary || s instanceof Remote) {
                    Counts quarkCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Other/unknown/unparseable", k -> new Counts());
                    ++quarkCounts.fileCount;
                    LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Other/unknown/unparseable", s.getClass().getName(), 0, hasParseFailure));
                } else {
                    int genericLineCount = LanguageComposition.genericLineCount(s);
                    if (s.getClass().getName().startsWith("org.openrewrite.cobol.tree.CobolPreprocessor$Copybook")) {
                        Counts copybookCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Copybook", k -> new Counts());
                        ++copybookCounts.fileCount;
                        copybookCounts.lineCount += genericLineCount;
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Copybook", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s.getClass().getName().startsWith("org.openrewrite.cobol.tree.Cobol")) {
                        Counts cobolCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Cobol", k -> new Counts());
                        ++cobolCounts.fileCount;
                        cobolCounts.lineCount += genericLineCount;
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Cobol", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof K) {
                        Counts kotlinCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Kotlin", k -> new Counts());
                        ++kotlinCounts.fileCount;
                        kotlinCounts.lineCount += CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Kotlin", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof G) {
                        Counts groovyCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Groovy", k -> new Counts());
                        ++groovyCounts.fileCount;
                        groovyCounts.lineCount += org.openrewrite.groovy.CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Groovy", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof Py) {
                        Counts pythonCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Python", k -> new Counts());
                        ++pythonCounts.fileCount;
                        pythonCounts.lineCount += genericLineCount;
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Python", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof J) {
                        Counts javaCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Java", k -> new Counts());
                        ++javaCounts.fileCount;
                        javaCounts.lineCount += CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Java", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof Json) {
                        Counts jsonCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Json", k -> new Counts());
                        ++jsonCounts.fileCount;
                        jsonCounts.lineCount += org.openrewrite.json.CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Json", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof Hcl) {
                        Counts hclCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Hcl", k -> new Counts());
                        ++hclCounts.fileCount;
                        hclCounts.lineCount += org.openrewrite.hcl.CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Hcl", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof Properties) {
                        Counts propertiesCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Properties", k -> new Counts());
                        ++propertiesCounts.fileCount;
                        propertiesCounts.lineCount += org.openrewrite.properties.CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Properties", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof Proto) {
                        Counts protobufCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Protobuf", k -> new Counts());
                        ++protobufCounts.fileCount;
                        protobufCounts.lineCount += org.openrewrite.protobuf.CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Protobuf", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof Xml) {
                        Counts xmlCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Xml", k -> new Counts());
                        ++xmlCounts.fileCount;
                        xmlCounts.lineCount += org.openrewrite.xml.CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Xml", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof Yaml) {
                        Counts yamlCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Yaml", k -> new Counts());
                        ++yamlCounts.fileCount;
                        yamlCounts.lineCount += org.openrewrite.yaml.CountLinesVisitor.countLines((Tree)s);
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Yaml", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof PlainText) {
                        Counts plainTextCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Plain text", k -> new Counts());
                        ++plainTextCounts.fileCount;
                        plainTextCounts.lineCount += genericLineCount;
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Plain text", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else if (s instanceof ParseError) {
                        Counts parseErrorCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Parse error", k -> new Counts());
                        ++parseErrorCounts.fileCount;
                        parseErrorCounts.lineCount += genericLineCount;
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Parse error", s.getClass().getName(), genericLineCount, hasParseFailure));
                    } else {
                        Counts unknownCounts = acc.getFolderToLanguageToCounts().computeIfAbsent(folderPath, k -> new HashMap()).computeIfAbsent("Unknown", k -> new Counts());
                        ++unknownCounts.fileCount;
                        unknownCounts.lineCount += genericLineCount;
                        LanguageComposition.this.perFileReport.insertRow(ctx, new LanguageCompositionPerFile.Row(s.getSourcePath().toString(), "Unknown", s.getClass().getName(), genericLineCount, hasParseFailure));
                    }
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        HashMap<String, Counts> languageToCount = new HashMap<String, Counts>();
        for (Map.Entry<String, Map<String, Counts>> entry : acc.getFolderToLanguageToCounts().entrySet()) {
            for (Map.Entry<String, Counts> languageEntry : entry.getValue().entrySet()) {
                this.perFolderReport.insertRow(ctx, new LanguageCompositionPerFolder.Row(entry.getKey(), languageEntry.getKey(), languageEntry.getValue().fileCount, languageEntry.getValue().lineCount));
                Counts counts = languageToCount.computeIfAbsent(languageEntry.getKey(), k -> new Counts());
                counts.fileCount += languageEntry.getValue().fileCount;
                counts.lineCount += languageEntry.getValue().lineCount;
            }
        }
        for (Map.Entry<String, Map<String, Counts>> entry : languageToCount.entrySet()) {
            this.perRepositoryReport.insertRow(ctx, new LanguageCompositionPerRepository.Row(entry.getKey(), ((Counts)((Object)entry.getValue())).fileCount, ((Counts)((Object)entry.getValue())).lineCount));
        }
        return Collections.emptyList();
    }

    private static int genericLineCount(SourceFile s) {
        LineCounter counter = new LineCounter();
        s.printAll((PrintOutputCapture)counter);
        return counter.getLineCount();
    }

    public LanguageCompositionPerRepository getPerRepositoryReport() {
        return this.perRepositoryReport;
    }

    public LanguageCompositionPerFolder getPerFolderReport() {
        return this.perFolderReport;
    }

    public LanguageCompositionPerFile getPerFileReport() {
        return this.perFileReport;
    }

    public String toString() {
        return "LanguageComposition(perRepositoryReport=" + (Object)((Object)this.getPerRepositoryReport()) + ", perFolderReport=" + (Object)((Object)this.getPerFolderReport()) + ", perFileReport=" + (Object)((Object)this.getPerFileReport()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LanguageComposition)) {
            return false;
        }
        LanguageComposition other = (LanguageComposition)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof LanguageComposition;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static class Accumulator {
        Map<String, Map<String, Counts>> folderToLanguageToCounts = new HashMap<String, Map<String, Counts>>();

        public Map<String, Map<String, Counts>> getFolderToLanguageToCounts() {
            return this.folderToLanguageToCounts;
        }

        public void setFolderToLanguageToCounts(Map<String, Map<String, Counts>> folderToLanguageToCounts) {
            this.folderToLanguageToCounts = folderToLanguageToCounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Map<String, Counts>> this$folderToLanguageToCounts = this.getFolderToLanguageToCounts();
            Map<String, Map<String, Counts>> other$folderToLanguageToCounts = other.getFolderToLanguageToCounts();
            return !(this$folderToLanguageToCounts == null ? other$folderToLanguageToCounts != null : !((Object)this$folderToLanguageToCounts).equals(other$folderToLanguageToCounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Accumulator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Map<String, Counts>> $folderToLanguageToCounts = this.getFolderToLanguageToCounts();
            result = result * 59 + ($folderToLanguageToCounts == null ? 43 : ((Object)$folderToLanguageToCounts).hashCode());
            return result;
        }

        public String toString() {
            return "LanguageComposition.Accumulator(folderToLanguageToCounts=" + this.getFolderToLanguageToCounts() + ")";
        }
    }

    private static class Counts {
        int lineCount;
        int fileCount;

        private Counts() {
        }
    }

    private static class LineCounter
    extends PrintOutputCapture<Integer> {
        private int count;

        public LineCounter() {
            super((Object)0);
        }

        public PrintOutputCapture<Integer> append(char c) {
            if (c == '\n') {
                ++this.count;
            }
            return this;
        }

        public PrintOutputCapture<Integer> append(@Nullable String text) {
            if (text == null) {
                return this;
            }
            if (text.contains("\n")) {
                this.count += text.split("([\r\n]+)").length;
            }
            return this;
        }

        int getLineCount() {
            return this.count;
        }
    }
}

