/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class LanguageCompositionPerFolder
extends DataTable<Row> {
    public LanguageCompositionPerFolder(Recipe recipe) {
        super(recipe, "Per-folder language composition report", "A list of folders and the language composition and line counts of their contents.");
    }

    public static final class Row {
        @Column(displayName="Folder path", description="The path to the folder relative to repository root.")
        private final String folderPath;
        @Column(displayName="Language", description="Language of the source file.")
        private final String language;
        @Column(displayName="File count", description="Count of files of this language.")
        private final int fileCount;
        @Column(displayName="Line count", description="Count of lines of this language.")
        private final int lineCount;

        public Row(String folderPath, String language, int fileCount, int lineCount) {
            this.folderPath = folderPath;
            this.language = language;
            this.fileCount = fileCount;
            this.lineCount = lineCount;
        }

        public String getFolderPath() {
            return this.folderPath;
        }

        public String getLanguage() {
            return this.language;
        }

        public int getFileCount() {
            return this.fileCount;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getFileCount() != other.getFileCount()) {
                return false;
            }
            if (this.getLineCount() != other.getLineCount()) {
                return false;
            }
            String this$folderPath = this.getFolderPath();
            String other$folderPath = other.getFolderPath();
            if (this$folderPath == null ? other$folderPath != null : !this$folderPath.equals(other$folderPath)) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            return !(this$language == null ? other$language != null : !this$language.equals(other$language));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFileCount();
            result = result * 59 + this.getLineCount();
            String $folderPath = this.getFolderPath();
            result = result * 59 + ($folderPath == null ? 43 : $folderPath.hashCode());
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            return result;
        }

        public String toString() {
            return "LanguageCompositionPerFolder.Row(folderPath=" + this.getFolderPath() + ", language=" + this.getLanguage() + ", fileCount=" + this.getFileCount() + ", lineCount=" + this.getLineCount() + ")";
        }
    }
}

