/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class LanguageCompositionPerFile
extends DataTable<Row> {
    public LanguageCompositionPerFile(Recipe recipe) {
        super(recipe, "Per-file language composition report", "A list of individual files and their language composition.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file.")
        private final String sourcePath;
        @Column(displayName="Language", description="The language of the source file.")
        private final String language;
        @Column(displayName="LST type", description="The Lossless Semantic Tree type of this source file.")
        private final String sourceFileType;
        @Column(displayName="Lines of text", description="The number of lines of text in the source file. No language-specific knowledge to skip comments, blank lines, or any other non-code line.")
        private final Integer linesOfText;
        @Column(displayName="Has parse failures", description="True if the file failed to parse, otherwise false.")
        private final Boolean hasParseFailures;

        @Generated
        public Row(String sourcePath, String language, String sourceFileType, Integer linesOfText, Boolean hasParseFailures) {
            this.sourcePath = sourcePath;
            this.language = language;
            this.sourceFileType = sourceFileType;
            this.linesOfText = linesOfText;
            this.hasParseFailures = hasParseFailures;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getLanguage() {
            return this.language;
        }

        @Generated
        public String getSourceFileType() {
            return this.sourceFileType;
        }

        @Generated
        public Integer getLinesOfText() {
            return this.linesOfText;
        }

        @Generated
        public Boolean getHasParseFailures() {
            return this.hasParseFailures;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$linesOfText = this.getLinesOfText();
            Integer other$linesOfText = other.getLinesOfText();
            if (this$linesOfText == null ? other$linesOfText != null : !((Object)this$linesOfText).equals(other$linesOfText)) {
                return false;
            }
            Boolean this$hasParseFailures = this.getHasParseFailures();
            Boolean other$hasParseFailures = other.getHasParseFailures();
            if (this$hasParseFailures == null ? other$hasParseFailures != null : !((Object)this$hasParseFailures).equals(other$hasParseFailures)) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            String this$sourceFileType = this.getSourceFileType();
            String other$sourceFileType = other.getSourceFileType();
            return !(this$sourceFileType == null ? other$sourceFileType != null : !this$sourceFileType.equals(other$sourceFileType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $linesOfText = this.getLinesOfText();
            result = result * 59 + ($linesOfText == null ? 43 : ((Object)$linesOfText).hashCode());
            Boolean $hasParseFailures = this.getHasParseFailures();
            result = result * 59 + ($hasParseFailures == null ? 43 : ((Object)$hasParseFailures).hashCode());
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            String $sourceFileType = this.getSourceFileType();
            result = result * 59 + ($sourceFileType == null ? 43 : $sourceFileType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LanguageCompositionPerFile.Row(sourcePath=" + this.getSourcePath() + ", language=" + this.getLanguage() + ", sourceFileType=" + this.getSourceFileType() + ", linesOfText=" + this.getLinesOfText() + ", hasParseFailures=" + this.getHasParseFailures() + ")";
        }
    }
}

