/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.android;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.J;

public final class ChangeAndroidSdkVersion
extends Recipe {
    @Option(displayName="Android SDK Version", description="The version of the Android SDK to use.", example="35")
    private final Integer version;

    public String getDisplayName() {
        return "Change Android SDK version";
    }

    public String getDescription() {
        return "Change `compileSdk`, `compileSdkVersion`, `targetSdk` and `targetSdkVersion` in an Android Gradle build file to the argument version.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                String simpleName = mi.getSimpleName();
                if ("compileSdk".equals(simpleName) || "targetSdk".equals(simpleName)) {
                    return mi.withArguments(ListUtils.map((List)mi.getArguments(), arg -> {
                        if (arg instanceof J.Literal && !ChangeAndroidSdkVersion.this.version.equals(((J.Literal)arg).getValue())) {
                            return ((J.Literal)arg).withValue((Object)ChangeAndroidSdkVersion.this.version).withValueSource(String.valueOf(ChangeAndroidSdkVersion.this.version));
                        }
                        return arg;
                    }));
                }
                if ("compileSdkVersion".equals(simpleName) || "targetSdkVersion".equals(simpleName)) {
                    return mi.withArguments(ListUtils.map((List)mi.getArguments(), arg -> {
                        if (arg instanceof J.Literal && !String.valueOf(ChangeAndroidSdkVersion.this.version).equals(((J.Literal)arg).getValue())) {
                            return ((J.Literal)arg).withValue((Object)String.valueOf(ChangeAndroidSdkVersion.this.version)).withValueSource(String.format("\"%d\"", ChangeAndroidSdkVersion.this.version));
                        }
                        return arg;
                    }));
                }
                return mi;
            }
        });
    }

    @Generated
    public ChangeAndroidSdkVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public String toString() {
        return "ChangeAndroidSdkVersion(version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeAndroidSdkVersion)) {
            return false;
        }
        ChangeAndroidSdkVersion other = (ChangeAndroidSdkVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeAndroidSdkVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }
}

