/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codehaus.plexus;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class PlexusFileUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`PlexusFileUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.codehaus.plexus.PlexusFileUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new DeleteDirectoryFileRecipe(), new DeleteDirectoryStringRecipe(), new FileExistsStringRecipe(), new GetFileRecipe()});
    }

    @NonNullApi
    public static class DeleteDirectoryFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.deleteDirectory(File)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.deleteDirectory(File directory)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.deleteDirectory(#{dir:any(java.io.File)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"plexus-utils"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.apache.commons.io.FileUtils.deleteDirectory(#{dir:any(java.io.File)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"commons-io"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils deleteDirectory(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DeleteDirectoryStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.deleteDirectory(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.deleteDirectory(String directory)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.deleteDirectory(#{dir:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"plexus-utils"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.apache.commons.io.FileUtils.deleteDirectory(new java.io.File(#{dir:any(java.lang.String)}))").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"commons-io"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils deleteDirectory(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FileExistsStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.fileExists(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.fileExists(String fileName)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.fileExists(#{fileName:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"plexus-utils"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"new java.io.File(#{fileName:any(java.lang.String)}).exists()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils fileExists(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class GetFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.getFile(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.getFile(String fileName)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.codehaus.plexus.util.FileUtils.getFile(#{fileName:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"plexus-utils"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"new java.io.File(#{fileName:any(java.lang.String)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils getFile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

