/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.commons.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ApacheCommonsFileUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ApacheCommonsFileUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.apache.commons.io.ApacheCommonsFileUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new GetFileRecipe(), new WriteStringToFileRecipe()});
    }

    @NonNullApi
    public static class GetFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.getFile(String...)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `FileUtils.getFile(String... name)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.apache.commons.io.FileUtils.getFile(#{name:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"new java.io.File(#{name:any(java.lang.String)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.io.FileUtils", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.io.FileUtils getFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class WriteStringToFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.writeStringToFile(File, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `FileUtils.writeStringToFile(File file, String data)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.apache.commons.io.FileUtils.writeStringToFile(#{a:any(java.io.File)}, #{s:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.write(#{a:any(java.io.File)}.toPath(), #{s:any(java.lang.String)}.getBytes());").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.io.FileUtils", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.io.FileUtils writeStringToFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

