/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.poi;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ReplaceSetCellTypeRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace `Cell.setCellType(int)` with `Cell.setCellType(CellType)`";
    }

    public String getDescription() {
        return "Replace `Cell.setCellType(int)` with equivalent `Cell.setCellType(CellType)`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ReplaceSetCellTypeNumericRecipe(), new ReplaceSetCellTypeStringRecipe(), new ReplaceSetCellTypeFormulaRecipe(), new ReplaceSetCellTypeBlankRecipe(), new ReplaceSetCellTypeBooleanRecipe(), new ReplaceSetCellTypeErrorRecipe()});
    }

    @NullMarked
    public static class ReplaceSetCellTypeNumericRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_NUMERIC)` with `Cell.setCellType(CellType.NUMERIC)`";
        }

        public String getDescription() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_NUMERIC)` with `Cell.setCellType(CellType.NUMERIC)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeInt = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(0);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_NUMERIC);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_NUMERIC);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.CellType.NUMERIC);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeInt.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Cell", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Cell setCellType(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceSetCellTypeStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_STRING)` with `Cell.setCellType(CellType.STRING)`";
        }

        public String getDescription() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_STRING)` with `Cell.setCellType(CellType.STRING)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeInt = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(1);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_STRING);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_STRING);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.CellType.STRING);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeInt.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Cell", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Cell setCellType(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceSetCellTypeFormulaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_FORMULA)` with `Cell.setCellType(CellType.FORMULA)`";
        }

        public String getDescription() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_FORMULA)` with `Cell.setCellType(CellType.FORMULA)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeInt = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(2);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_FORMULA);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_FORMULA);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.CellType.FORMULA);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeInt.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Cell", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Cell setCellType(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceSetCellTypeBlankRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_BLANK)` with `Cell.setCellType(CellType.BLANK)`";
        }

        public String getDescription() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_BLANK)` with `Cell.setCellType(CellType.BLANK)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeInt = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(3);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_BLANK);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_BLANK);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.CellType.BLANK);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeInt.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Cell", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Cell setCellType(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceSetCellTypeBooleanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_BOOLEAN)` with `Cell.setCellType(CellType.BOOLEAN)`";
        }

        public String getDescription() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_BOOLEAN)` with `Cell.setCellType(CellType.BOOLEAN)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeInt = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(4);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_BOOLEAN);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_BOOLEAN);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.CellType.BOOLEAN);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeInt.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Cell", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Cell setCellType(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceSetCellTypeErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_ERROR)` with `Cell.setCellType(CellType.ERROR)`";
        }

        public String getDescription() {
            return "Replace `Cell.setCellType(Cell.CELL_TYPE_ERROR)` with `Cell.setCellType(CellType.ERROR)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeInt = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(5);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_ERROR);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_ERROR);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.CellType.ERROR);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeInt.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Cell", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Cell setCellType(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

