/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.commons.io;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ApacheFileUtilsToJavaFiles
extends Recipe {
    public String getDisplayName() {
        return "Prefer `java.nio.file.Files`";
    }

    public String getDescription() {
        return "Prefer the Java standard library's `java.nio.file.Files` over third-party usage of apache's `apache.commons.io.FileUtils`.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("apache", "commons"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.io.FileUtils", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher readFileToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readFileToByteArray(java.io.File)");
            private final MethodMatcher readLinesToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readLines(java.io.File)");
            private final MethodMatcher readLinesWithCharsetToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readLines(java.io.File, java.nio.charset.Charset)");
            private final MethodMatcher readLinesWithCharsetIdToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readLines(java.io.File, String)");

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
                if (c != cu) {
                    this.maybeAddImport("java.nio.file.Files");
                    this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                }
                return c;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (this.readFileToByteArrayMatcher.matches((MethodCall)mi)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"Files.readAllBytes(#{any(java.io.File)}.toPath())").imports(new String[]{"java.nio.file.Files"}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)});
                }
                if (this.readLinesToByteArrayMatcher.matches((MethodCall)mi)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"Files.readAllLines(#{any(java.io.File)}.toPath())").imports(new String[]{"java.nio.file.Files"}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)});
                }
                if (this.readLinesWithCharsetToByteArrayMatcher.matches((MethodCall)mi)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"Files.readAllLines(#{any(java.io.File)}.toPath(), #{any(java.nio.charset.Charset)})").imports(new String[]{"java.nio.file.Files", "java.nio.charset.Charset"}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getArguments().get(1)});
                }
                if (this.readLinesWithCharsetIdToByteArrayMatcher.matches((MethodCall)mi)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"Files.readAllLines(#{any(java.io.File)}.toPath(), Charset.forName(#{any(String)}))").imports(new String[]{"java.nio.file.Files", "java.nio.charset.Charset"}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getArguments().get(1)});
                }
                return mi;
            }
        });
    }
}

