/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.poi;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class ReplaceSetCellType
extends Recipe {
    private static final MethodMatcher SET_CELL_TYPE = new MethodMatcher("org.apache.poi.ss.usermodel.Cell#setCellType(..)");
    private @Nullable JavaTemplate numericLiteral;
    private @Nullable JavaTemplate numericField;
    private @Nullable JavaTemplate numericStaticField;
    private @Nullable JavaTemplate stringLiteral;
    private @Nullable JavaTemplate stringField;
    private @Nullable JavaTemplate stringStaticField;
    private @Nullable JavaTemplate blankLiteral;
    private @Nullable JavaTemplate blankField;
    private @Nullable JavaTemplate blankStaticField;
    private @Nullable JavaTemplate formulaLiteral;
    private @Nullable JavaTemplate formulaField;
    private @Nullable JavaTemplate formulaStaticField;
    private @Nullable JavaTemplate booleanLiteral;
    private @Nullable JavaTemplate booleanField;
    private @Nullable JavaTemplate booleanStaticField;
    private @Nullable JavaTemplate errorLiteral;
    private @Nullable JavaTemplate errorField;
    private @Nullable JavaTemplate errorStaticField;

    public String getDisplayName() {
        return "Apache POI use `Cell.setCellType(CellType)`";
    }

    public String getDescription() {
        return "`Cell.setCellType()` can be configured with either an integer or a the `CellType` enumeration. It is clearer and less error-prone to use the `CellType` enumeration, so this recipe converts all `setCellType()` calls to use it.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(SET_CELL_TYPE), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!SET_CELL_TYPE.matches((MethodCall)m)) {
                    return m;
                }
                m = this.numeric(m, this.getCursor(), ctx);
                m = this.string(m, this.getCursor(), ctx);
                m = this.blank(m, this.getCursor(), ctx);
                m = this.formula(m, this.getCursor(), ctx);
                m = this.bool(m, this.getCursor(), ctx);
                m = this.error(m, this.getCursor(), ctx);
                return m;
            }

            private J.MethodInvocation numeric(J.MethodInvocation m, Cursor c, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (TypeUtils.isAssignableTo((String)"org.apache.poi.ss.usermodel.CellType", (JavaType)((Expression)m.getArguments().get(0)).getType())) {
                    return m;
                }
                if (ReplaceSetCellType.this.numericLiteral == null || ReplaceSetCellType.this.numericField == null || ReplaceSetCellType.this.numericStaticField == null) {
                    ReplaceSetCellType.this.numericLiteral = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(0);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.numericField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_NUMERIC);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.numericStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_NUMERIC);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                }
                if ((matcher = ReplaceSetCellType.this.numericLiteral.matcher(c)).find() || (matcher = ReplaceSetCellType.this.numericField.matcher(c)).find() || (matcher = ReplaceSetCellType.this.numericStaticField.matcher(c)).find()) {
                    this.maybeAddImport("org.apache.poi.ss.usermodel.CellType");
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(CellType.NUMERIC);").imports(new String[]{"org.apache.poi.ss.usermodel.CellType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(c, m.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    this.setCursor(new Cursor(c.getParent(), (Object)m));
                }
                return m;
            }

            private J.MethodInvocation string(J.MethodInvocation m, Cursor c, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (TypeUtils.isAssignableTo((String)"org.apache.poi.ss.usermodel.CellType", (JavaType)((Expression)m.getArguments().get(0)).getType())) {
                    return m;
                }
                if (ReplaceSetCellType.this.stringLiteral == null || ReplaceSetCellType.this.stringField == null || ReplaceSetCellType.this.stringStaticField == null) {
                    ReplaceSetCellType.this.stringLiteral = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(1);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.stringField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_STRING);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.stringStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_STRING);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                }
                if ((matcher = ReplaceSetCellType.this.stringLiteral.matcher(c)).find() || (matcher = ReplaceSetCellType.this.stringField.matcher(c)).find() || (matcher = ReplaceSetCellType.this.stringStaticField.matcher(c)).find()) {
                    this.maybeAddImport("org.apache.poi.ss.usermodel.CellType");
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(CellType.STRING);").imports(new String[]{"org.apache.poi.ss.usermodel.CellType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(c, m.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    this.setCursor(new Cursor(c.getParent(), (Object)m));
                }
                return m;
            }

            private J.MethodInvocation formula(J.MethodInvocation m, Cursor c, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (TypeUtils.isAssignableTo((String)"org.apache.poi.ss.usermodel.CellType", (JavaType)((Expression)m.getArguments().get(0)).getType())) {
                    return m;
                }
                if (ReplaceSetCellType.this.formulaLiteral == null || ReplaceSetCellType.this.formulaField == null || ReplaceSetCellType.this.formulaStaticField == null) {
                    ReplaceSetCellType.this.formulaLiteral = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(2);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.formulaField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_FORMULA);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.formulaStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_FORMULA);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                }
                if ((matcher = ReplaceSetCellType.this.formulaLiteral.matcher(c)).find() || (matcher = ReplaceSetCellType.this.formulaField.matcher(c)).find() || (matcher = ReplaceSetCellType.this.formulaStaticField.matcher(c)).find()) {
                    this.maybeAddImport("org.apache.poi.ss.usermodel.CellType");
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(CellType.FORMULA);").imports(new String[]{"org.apache.poi.ss.usermodel.CellType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(c, m.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    this.setCursor(new Cursor(c.getParent(), (Object)m));
                }
                return m;
            }

            private J.MethodInvocation blank(J.MethodInvocation m, Cursor c, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (TypeUtils.isAssignableTo((String)"org.apache.poi.ss.usermodel.CellType", (JavaType)((Expression)m.getArguments().get(0)).getType())) {
                    return m;
                }
                if (ReplaceSetCellType.this.blankLiteral == null || ReplaceSetCellType.this.blankField == null || ReplaceSetCellType.this.blankStaticField == null) {
                    ReplaceSetCellType.this.blankLiteral = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(3);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.blankField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_BLANK);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.blankStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_BLANK);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                }
                if ((matcher = ReplaceSetCellType.this.blankLiteral.matcher(c)).find() || (matcher = ReplaceSetCellType.this.blankField.matcher(c)).find() || (matcher = ReplaceSetCellType.this.blankStaticField.matcher(c)).find()) {
                    this.maybeAddImport("org.apache.poi.ss.usermodel.CellType");
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(CellType.BLANK);").imports(new String[]{"org.apache.poi.ss.usermodel.CellType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(c, m.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    this.setCursor(new Cursor(c.getParent(), (Object)m));
                }
                return m;
            }

            private J.MethodInvocation bool(J.MethodInvocation m, Cursor c, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (TypeUtils.isAssignableTo((String)"org.apache.poi.ss.usermodel.CellType", (JavaType)((Expression)m.getArguments().get(0)).getType())) {
                    return m;
                }
                if (ReplaceSetCellType.this.booleanLiteral == null || ReplaceSetCellType.this.booleanField == null || ReplaceSetCellType.this.booleanStaticField == null) {
                    ReplaceSetCellType.this.booleanLiteral = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(4);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.booleanField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_BOOLEAN);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.booleanStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_BOOLEAN);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                }
                if ((matcher = ReplaceSetCellType.this.booleanLiteral.matcher(c)).find() || (matcher = ReplaceSetCellType.this.booleanField.matcher(c)).find() || (matcher = ReplaceSetCellType.this.booleanStaticField.matcher(c)).find()) {
                    this.maybeAddImport("org.apache.poi.ss.usermodel.CellType");
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(CellType.BOOLEAN);").imports(new String[]{"org.apache.poi.ss.usermodel.CellType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(c, m.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    this.setCursor(new Cursor(c.getParent(), (Object)m));
                }
                return m;
            }

            private J.MethodInvocation error(J.MethodInvocation m, Cursor c, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (TypeUtils.isAssignableTo((String)"org.apache.poi.ss.usermodel.CellType", (JavaType)((Expression)m.getArguments().get(0)).getType())) {
                    return m;
                }
                if (ReplaceSetCellType.this.errorLiteral == null || ReplaceSetCellType.this.errorField == null || ReplaceSetCellType.this.errorStaticField == null) {
                    ReplaceSetCellType.this.errorLiteral = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(5);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.errorField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(#{cell}.CELL_TYPE_ERROR);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                    ReplaceSetCellType.this.errorStaticField = JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(org.apache.poi.ss.usermodel.Cell.CELL_TYPE_ERROR);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build();
                }
                if ((matcher = ReplaceSetCellType.this.errorLiteral.matcher(c)).find() || (matcher = ReplaceSetCellType.this.errorField.matcher(c)).find() || (matcher = ReplaceSetCellType.this.errorStaticField.matcher(c)).find()) {
                    this.maybeAddImport("org.apache.poi.ss.usermodel.CellType");
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{cell:any(org.apache.poi.ss.usermodel.Cell)}.setCellType(CellType.ERROR);").imports(new String[]{"org.apache.poi.ss.usermodel.CellType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(c, m.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    this.setCursor(new Cursor(c.getParent(), (Object)m));
                }
                return m;
            }
        });
    }
}

