/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import java.nio.charset.Charset;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.MethodCall;

public class MigrateStringEntityStringCharsetConstructor
extends Recipe {
    private static final MethodMatcher MATCHER_FOR_4x = new MethodMatcher("org.apache.http.entity.StringEntity <constructor>(String, String)");
    private static final MethodMatcher MATCHER_FOR_5x = new MethodMatcher("org.apache.hc.core5.http.io.entity.StringEntity <constructor>(String, String)");

    public String getDisplayName() {
        return "Replace `new StringEntity(String, String)` with `new StringEntity(String, Charset)`";
    }

    public String getDescription() {
        return "Replace `new StringEntity(String, String)` with `new StringEntity(String, Charset)` to eliminate literal usage for charset parameters.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(MATCHER_FOR_4x), new UsesMethod(MATCHER_FOR_5x)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
                if (MATCHER_FOR_4x.matches((MethodCall)nc) || MATCHER_FOR_5x.matches((MethodCall)nc)) {
                    return nc.withArguments(ListUtils.mapLast((List)nc.getArguments(), arg -> {
                        String argValue;
                        if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String && Charset.isSupported(argValue = (String)((J.Literal)arg).getValue())) {
                            String name = Charset.forName(argValue).name().replace("-", "_");
                            this.maybeAddImport("java.nio.charset.StandardCharsets");
                            return (Expression)JavaTemplate.apply((String)("java.nio.charset.StandardCharsets." + name), (Cursor)new Cursor(this.getCursor(), arg), (JavaCoordinates)arg.getCoordinates().replace(), (Object[])new Object[0]);
                        }
                        return arg;
                    }));
                }
                return nc;
            }
        });
    }
}

