/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.policy.BlockPolicy;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class EmptyBlock
extends CheckstyleRefactorVisitor {
    private static final Set<Token> DEFAULT_TOKENS = Stream.of(Token.LITERAL_WHILE, Token.LITERAL_TRY, Token.LITERAL_FINALLY, Token.LITERAL_DO, Token.LITERAL_IF, Token.LITERAL_ELSE, Token.LITERAL_FOR, Token.INSTANCE_INIT, Token.STATIC_INIT, Token.LITERAL_SWITCH, Token.LITERAL_SYNCHRONIZED).collect(Collectors.toSet());
    private BlockPolicy block;
    private Set<Token> tokens;

    public EmptyBlock() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.block = m.propAsOptionValue(BlockPolicy::valueOf, BlockPolicy.Statement);
        this.tokens = m.propAsTokens(Token.class, DEFAULT_TOKENS);
    }

    public J visitWhileLoop(J.WhileLoop whileLoop) {
        J.WhileLoop w = (J.WhileLoop)this.refactor((Tree)whileLoop, x$0 -> super.visitWhileLoop(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_WHILE) && this.isEmptyBlock(w.getBody())) {
            J.Block body = (J.Block)w.getBody();
            w = w.withBody((Statement)body.withStatements(Collections.singletonList(new J.Continue(Tree.randomId(), null, this.formatter.format((Tree)body)))));
        }
        return w;
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
        J.DoWhileLoop w = (J.DoWhileLoop)this.refactor((Tree)doWhileLoop, x$0 -> super.visitDoWhileLoop(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_WHILE) && this.isEmptyBlock(w.getBody())) {
            J.Block body = (J.Block)w.getBody();
            w = w.withBody((Statement)body.withStatements(Collections.singletonList(new J.Continue(Tree.randomId(), null, this.formatter.format((Tree)body)))));
        }
        return w;
    }

    public J visitBlock(J.Block<J> block) {
        J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
        AtomicBoolean filtered = new AtomicBoolean(false);
        List statements = b.getStatements().stream().map(s -> {
            if (!(s instanceof J.Block)) {
                return s;
            }
            J.Block nestedBlock = (J.Block)s;
            if (this.isEmptyBlock((Statement)nestedBlock) && (this.tokens.contains((Object)Token.STATIC_INIT) && nestedBlock.getStatic() != null || this.tokens.contains((Object)Token.INSTANCE_INIT) && nestedBlock.getStatic() == null)) {
                filtered.set(true);
                return null;
            }
            return nestedBlock;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return filtered.get() ? b.withStatements(statements) : b;
    }

    public J visitCatch(J.Try.Catch catzh) {
        J.Try.Catch c = (J.Try.Catch)this.refactor((Tree)catzh, x$0 -> super.visitCatch(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_CATCH) && this.isEmptyBlock((Statement)c.getBody())) {
            JavaType.Class throwClass;
            String throwName;
            JavaType.Class exceptionClassType;
            TypeTree exceptionType = ((J.VariableDecls)c.getParam().getTree()).getTypeExpr();
            JavaType.Class clazz = exceptionClassType = exceptionType == null ? null : TypeUtils.asClass((JavaType)exceptionType.getType());
            if (exceptionClassType != null && exceptionClassType.getFullyQualifiedName().equals("java.io.IOException")) {
                throwName = "UncheckedIOException";
                throwClass = JavaType.Class.build((String)"java.io.UncheckedIOException");
                this.maybeAddImport((JavaType.FullyQualified)throwClass);
            } else {
                throwName = "RuntimeException";
                throwClass = JavaType.Class.build((String)"java.lang.RuntimeException");
            }
            c = c.withBody(c.getBody().withStatements(Collections.singletonList(new J.Throw(Tree.randomId(), (Expression)new J.NewClass(Tree.randomId(), null, new J.NewClass.New(Tree.randomId(), Formatting.EMPTY), (TypeTree)J.Ident.build((UUID)Tree.randomId(), (String)throwName, (JavaType)throwClass, (Formatting)Formatting.format((String)" ")), new J.NewClass.Arguments(Tree.randomId(), Collections.singletonList(J.Ident.build((UUID)Tree.randomId(), (String)((J.VariableDecls.NamedVar)((J.VariableDecls)c.getParam().getTree()).getVars().iterator().next()).getSimpleName(), (JavaType)(exceptionType == null ? null : exceptionType.getType()), (Formatting)Formatting.EMPTY)), Formatting.EMPTY), null, (JavaType)throwClass, Formatting.format((String)" ")), this.formatter.format((Tree)c.getBody())))));
        }
        return c;
    }

    public J visitTry(J.Try tryable) {
        J.Try t = (J.Try)this.refactor((Tree)tryable, x$0 -> super.visitTry(x$0));
        if (this.tokens.contains((Object)Token.LITERAL_TRY) && this.isEmptyBlock((Statement)t.getBody())) {
            this.andThen((RefactorVisitor)new DeleteStatement.Scoped((Statement)tryable));
        } else if (this.tokens.contains((Object)Token.LITERAL_FINALLY) && t.getFinally() != null && this.isEmptyBlock((Statement)t.getFinally().getBody())) {
            t = t.withFinally(null);
        }
        return t;
    }

    public J visitIf(J.If iff) {
        List<Statement> elseStatementBody;
        J.If i = (J.If)this.refactor((Tree)iff, x$0 -> super.visitIf(x$0));
        if (!this.tokens.contains((Object)Token.LITERAL_IF) || !this.isEmptyBlock(i.getThenPart())) {
            return i;
        }
        if (i.getElsePart() == null) {
            this.andThen((RefactorVisitor)new ExtractSideEffectsOfIfCondition(this.enclosingBlock(), i));
            return i;
        }
        J.Parentheses cond = i.getIfCondition();
        if (cond.getTree() instanceof J.Binary) {
            J.Binary binary = (J.Binary)cond.getTree();
            J.Binary.Operator op = binary.getOperator();
            if (op instanceof J.Binary.Operator.Equal) {
                cond = cond.withTree((J)binary.withOperator((J.Binary.Operator)new J.Binary.Operator.NotEqual(op.getId(), op.getFormatting())));
            } else if (op instanceof J.Binary.Operator.NotEqual) {
                cond = cond.withTree((J)binary.withOperator((J.Binary.Operator)new J.Binary.Operator.Equal(op.getId(), op.getFormatting())));
            } else if (op instanceof J.Binary.Operator.LessThan) {
                cond = cond.withTree((J)binary.withOperator((J.Binary.Operator)new J.Binary.Operator.GreaterThanOrEqual(op.getId(), op.getFormatting())));
            } else if (op instanceof J.Binary.Operator.LessThanOrEqual) {
                cond = cond.withTree((J)binary.withOperator((J.Binary.Operator)new J.Binary.Operator.GreaterThan(op.getId(), op.getFormatting())));
            } else if (op instanceof J.Binary.Operator.GreaterThan) {
                cond = cond.withTree((J)binary.withOperator((J.Binary.Operator)new J.Binary.Operator.LessThanOrEqual(op.getId(), op.getFormatting())));
            } else if (op instanceof J.Binary.Operator.GreaterThanOrEqual) {
                cond = cond.withTree((J)binary.withOperator((J.Binary.Operator)new J.Binary.Operator.LessThan(op.getId(), op.getFormatting())));
            }
            i = i.withIfCondition(cond);
        }
        if (i.getElsePart() == null) {
            return i.withThenPart((Statement)new J.Empty(Tree.randomId(), Formatting.EMPTY)).withElsePart(null);
        }
        J.Block thenPart = (J.Block)i.getThenPart();
        Tree containing = this.getCursor().getParentOrThrow().getTree();
        Statement elseStatement = i.getElsePart().getStatement();
        if (elseStatement instanceof J.Block) {
            elseStatementBody = ((J.Block)elseStatement).getStatements();
        } else if (elseStatement instanceof J.If) {
            String prefix = "\n" + IntStream.range(0, thenPart.getIndent()).mapToObj(n -> " ").collect(Collectors.joining(""));
            elseStatementBody = Collections.singletonList((J)elseStatement.withPrefix(prefix));
            this.andThen((RefactorVisitor)this.formatter.shiftRight((Tree)elseStatement, (Tree)i.getThenPart(), containing));
        } else {
            elseStatementBody = Collections.singletonList(elseStatement);
            this.andThen((RefactorVisitor)this.formatter.shiftRight((Tree)elseStatement, (Tree)i.getThenPart(), containing));
        }
        return i.withThenPart((Statement)thenPart.withStatements(elseStatementBody)).withElsePart(null);
    }

    public J visitSynchronized(J.Synchronized synch) {
        if (this.tokens.contains((Object)Token.LITERAL_SYNCHRONIZED) && this.isEmptyBlock((Statement)synch.getBody())) {
            this.andThen((RefactorVisitor)new DeleteStatement.Scoped((Statement)synch));
        }
        return super.visitSynchronized(synch);
    }

    public J visitSwitch(J.Switch switzh) {
        if (this.tokens.contains((Object)Token.LITERAL_SWITCH) && this.isEmptyBlock((Statement)switzh.getCases())) {
            this.andThen((RefactorVisitor)new DeleteStatement.Scoped((Statement)switzh));
        }
        return super.visitSwitch(switzh);
    }

    private boolean isEmptyBlock(Statement blockNode) {
        return this.block.equals((Object)BlockPolicy.Statement) && blockNode instanceof J.Block && ((J.Block)blockNode).getStatements().isEmpty();
    }

    private static class ExtractSideEffectsOfIfCondition
    extends JavaRefactorVisitor {
        private final J.Block<?> enclosingBlock;
        private final J.If toExtract;

        public ExtractSideEffectsOfIfCondition(J.Block<?> enclosingBlock, J.If toExtract) {
            this.enclosingBlock = enclosingBlock;
            this.toExtract = toExtract;
        }

        public J visitBlock(J.Block<J> block) {
            J.Block b = (J.Block)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
            if (this.enclosingBlock.isScope(block)) {
                ArrayList<J> statements = new ArrayList<J>(b.getStatements().size());
                for (J statement : b.getStatements()) {
                    if (statement == this.toExtract) {
                        ((Expression)this.toExtract.getIfCondition().getTree()).getSideEffects().stream().map(s -> (J)s.withFormatting(this.formatter.format((Tree)block))).forEach(statements::add);
                        continue;
                    }
                    statements.add(statement);
                }
                b = b.withStatements(statements);
            }
            return b;
        }
    }
}

