/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.List;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.WhitespaceChecks;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class GenericWhitespace
extends CheckstyleRefactorVisitor {
    public GenericWhitespace() {
        this.setCursoringOn();
    }

    public J visitTypeParameters(J.TypeParameters typeParams) {
        J.TypeParameters t = (J.TypeParameters)this.refactor((Tree)typeParams, x$0 -> super.visitTypeParameters(x$0));
        Tree tree = this.getCursor().getParentOrThrow().getTree();
        if (!(tree instanceof J.MethodDecl)) {
            if (WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)t)) {
                t = WhitespaceChecks.stripPrefixUpToLinebreak(t);
            }
            if (WhitespaceChecks.suffixStartsWithNonLinebreakWhitespace((Tree)t)) {
                t = WhitespaceChecks.stripPrefixUpToLinebreak(t);
            }
        }
        return t;
    }

    public J visitTypeParameter(J.TypeParameter typeParam) {
        J.TypeParameter t = (J.TypeParameter)this.refactor((Tree)typeParam, x$0 -> super.visitTypeParameter(x$0));
        List params = ((J.TypeParameters)this.getCursor().getParentOrThrow().getTree()).getParams();
        if (params.isEmpty()) {
            return t;
        }
        if (params.size() == 1) {
            if (WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)t)) {
                t = WhitespaceChecks.stripPrefixUpToLinebreak(t);
            }
            if (WhitespaceChecks.suffixStartsWithNonLinebreakWhitespace((Tree)t)) {
                t = WhitespaceChecks.stripSuffixUpToLinebreak(t);
            }
        } else if (params.get(0) == t) {
            if (WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)t)) {
                t = WhitespaceChecks.stripPrefixUpToLinebreak(t);
            }
        } else if (params.get(params.size() - 1) == t && WhitespaceChecks.suffixStartsWithNonLinebreakWhitespace((Tree)t)) {
            t = WhitespaceChecks.stripSuffixUpToLinebreak(t);
        }
        return t;
    }
}

