/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.openrewrite.AutoConfigure;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class StaticVariableName
extends CheckstyleRefactorVisitor {
    private static final Function<String, String> renamer = StaticVariableName::snakeCaseToCamel;
    private Pattern format;
    private boolean applyToPublic;
    private boolean applyToProtected;
    private boolean applyToPackage;
    private boolean applyToPrivate;

    public StaticVariableName() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.format = m.prop("format", Pattern.compile("^[a-z][a-zA-Z0-9]*$"));
        this.applyToPublic = m.prop("applyToPublic", true);
        this.applyToProtected = m.prop("applyToProtected", true);
        this.applyToPackage = m.prop("applyToPackage", true);
        this.applyToPrivate = m.prop("applyToPrivate", true);
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        J.VariableDecls multiVariable = (J.VariableDecls)this.getCursor().getParentOrThrow().getTree();
        if (multiVariable.hasModifier("static") && !this.format.matcher(variable.getSimpleName()).matches() && (this.applyToPublic && multiVariable.hasModifier("public") || this.applyToProtected && multiVariable.hasModifier("protected") || this.applyToPrivate && multiVariable.hasModifier("private") || this.applyToPackage && !multiVariable.hasModifier("public") && !multiVariable.hasModifier("protected") && !multiVariable.hasModifier("private"))) {
            JavaType.Class containingClassType = TypeUtils.asClass((JavaType)this.enclosingClass().getType());
            this.andThen((RefactorVisitor)new ChangeFieldName.Scoped(containingClassType, variable.getSimpleName(), renamer.apply(variable.getSimpleName())));
        }
        return super.visitVariable(variable);
    }

    static String snakeCaseToCamel(String value) {
        if (!value.matches("([A-Z0-9]+_*)+")) {
            return value;
        }
        StringBuilder camelName = new StringBuilder();
        char last = '\u0000';
        for (char c : value.toCharArray()) {
            if (c != '_') {
                camelName.append(last == '_' ? c : Character.toLowerCase(c));
            }
            last = c;
        }
        return camelName.toString();
    }
}

